<?xml version="1.0" encoding="UTF-8"?>

<!--
-------------------------------------------------------------------
 Licensed Materials - Property of IBM

 WebSphere Commerce

 (c) Copyright International Business Machines Corporation. 2009
     All rights reserved.

 US Government Users Restricted Rights - Use, duplication or
 disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

-------------------------------------------------------------------

---------------------------------------------------------------------
 The sample contained herein is provided to you "AS IS".

 It is furnished by IBM as a simple example and has not been
 thoroughly tested
 under all conditions.  IBM, therefore, cannot guarantee its
 reliability, serviceability or functionality.

 This sample may include the names of individuals, companies, brands
 and products in order to illustrate concepts as completely as
 possible.  All of these names
 are fictitious and any similarity to the names and addresses used by
 actual persons
 or business enterprises is entirely coincidental.
---------------------------------------------------------------------
-->

<xsl:stylesheet
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:datetime="http://exslt.org/dates-and-times"
		xmlns:oa="http://www.openapplications.org/oagis/9"
		xmlns:udt="http://www.openapplications.org/oagis/9/unqualifieddatatypes/1.1"
		xmlns:_wcf="http://www.ibm.com/xmlns/prod/commerce/9/foundation"
		xmlns:_sto="http://www.ibm.com/xmlns/prod/commerce/9/store"
		xmlns:_inv="http://www.ibm.com/xmlns/prod/commerce/9/inventory"
		xmlns:_ord="http://www.ibm.com/xmlns/prod/commerce/9/order"
		xmlns:test="http://test" exclude-result-prefixes="xalan test"
		version="1.0">
	<xsl:output method="xml" encoding="UTF-8" indent="yes" xalan:indent-amount="2" />
	<xsl:strip-space elements="*" />
	<xsl:template name="BodyToBody">
		<xsl:param name="body" />
		<xsl:variable name="order" select="$body/test:createOrderResponse/createOrderReturn" />
		<_ord:AcknowledgeOrder>
			<oa:ApplicationArea>
				<oa:CreationDateTime xsi:type="udt:DateTimeType"><xsl:value-of select="datetime:dateTime()" /></oa:CreationDateTime>
			</oa:ApplicationArea>
			<_ord:DataArea>
				<oa:Acknowledge />
				<_ord:Order>
					<_ord:OrderIdentifier>
						<_wcf:UniqueID><xsl:value-of select="$order/orderId" /></_wcf:UniqueID>
					</_ord:OrderIdentifier>
				</_ord:Order>
			</_ord:DataArea>
		</_ord:AcknowledgeOrder>
	</xsl:template>
</xsl:stylesheet>
