<?xml version="1.0" encoding="UTF-8"?>

<!--
-------------------------------------------------------------------
 Licensed Materials - Property of IBM

 WebSphere Commerce

 (c) Copyright International Business Machines Corporation. 2009
     All rights reserved.

 US Government Users Restricted Rights - Use, duplication or
 disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

-------------------------------------------------------------------

---------------------------------------------------------------------
 The sample contained herein is provided to you "AS IS".

 It is furnished by IBM as a simple example and has not been
 thoroughly tested
 under all conditions.  IBM, therefore, cannot guarantee its
 reliability, serviceability or functionality.

 This sample may include the names of individuals, companies, brands
 and products in order to illustrate concepts as completely as
 possible.  All of these names
 are fictitious and any similarity to the names and addresses used by
 actual persons
 or business enterprises is entirely coincidental.
---------------------------------------------------------------------
-->

<xsl:stylesheet
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:datetime="http://exslt.org/dates-and-times"
		xmlns:oa="http://www.openapplications.org/oagis/9"
		xmlns:udt="http://www.openapplications.org/oagis/9/unqualifieddatatypes/1.1"
		xmlns:_wcf="http://www.ibm.com/xmlns/prod/commerce/9/foundation"
		xmlns:_sto="http://www.ibm.com/xmlns/prod/commerce/9/store"
		xmlns:_inv="http://www.ibm.com/xmlns/prod/commerce/9/inventory"
		xmlns:_ord="http://www.ibm.com/xmlns/prod/commerce/9/order"
		xmlns:test="http://test" exclude-result-prefixes="xalan oa udt _wcf _sto _inv _ord"
		version="1.0">
	<xsl:output method="xml" encoding="UTF-8" indent="yes" xalan:indent-amount="2" />
	<xsl:strip-space elements="*" />
	<xsl:template name="BodyToBody">
		<xsl:param name="body" />
		<xsl:variable name="order"
			select="$body/_inv:ProcessInventoryRequirement/_inv:DataArea/_inv:InventoryRequirement" />
		<test:cancelInventoryReservations>
			<order>
				<orderId><xsl:value-of select="$order/_ord:OrderIdentifier/_wcf:UniqueID" /></orderId>
				<description xsi:nil="true" />
				<storeId><xsl:value-of select="$order/_ord:StoreIdentifier/_wcf:UniqueID" /></storeId>
				<userDn><xsl:value-of select="$order/_ord:BuyerIdentifier/_wcf:DistinguishedName" /></userDn>
				<status><xsl:value-of select="$order/_ord:OrderStatus/_ord:Status" /></status>
				<xsl:choose>
					<xsl:when test="$order/_ord:PlacedDate">
						<submissionDate><xsl:value-of select="$order/_ord:PlacedDate" /></submissionDate>
					</xsl:when>
					<xsl:otherwise>
						<submissionDate xsi:nil="true" />
					</xsl:otherwise>
				</xsl:choose>
				<orderItems>
					<xsl:for-each select="$order/_ord:OrderItem">
						<OrderItem>
							<orderItemId><xsl:value-of select="_ord:OrderItemIdentifier/_wcf:UniqueID" /></orderItemId>
							<sku><xsl:value-of select="_ord:CatalogEntryIdentifier/_wcf:ExternalIdentifier/_wcf:PartNumber" /></sku>
							<quantity>
								<value><xsl:value-of select="_ord:Quantity" /></value>
								<xsl:choose>
									<xsl:when test="_ord:Quantity/@uom">
										<uom><xsl:value-of select="_ord:Quantity/@uom" /></uom>
									</xsl:when>
									<xsl:otherwise>
										<uom>C62</uom>
									</xsl:otherwise>
								</xsl:choose>
							</quantity>
							<shippingModeId><xsl:value-of select="_ord:OrderItemShippingInfo/_ord:ShippingMode/_ord:ShippingModeIdentifier/_ord:ExternalIdentifier/_ord:ShipModeCode" /></shippingModeId>
							<fulfillmentCenterId><xsl:value-of select="_ord:FulfillmentCenter/_ord:FulfillmentCenterIdentifier/_wcf:Name" /></fulfillmentCenterId>
							<xsl:choose>
								<xsl:when test="_ord:OrderItemShippingInfo/_ord:RequestedShipDate">
									<requestedShipDate><xsl:value-of select="_ord:OrderItemShippingInfo/_ord:RequestedShipDate" /></requestedShipDate>
								</xsl:when>
								<xsl:otherwise>
									<requestedShipDate xsi:nil="true" />
								</xsl:otherwise>
							</xsl:choose>
							<status><xsl:value-of select="_ord:OrderItemStatus/_ord:Status" /></status>
							<inventoryStatus xsi:nil="true" />
							<availableDate xsi:nil="true" />
							<shipDate xsi:nil="true" />
							<attribute>
								<Attribute>
									<name>wcFulfillmentCenterId</name>
									<value><xsl:value-of select="_ord:FulfillmentCenter/_ord:FulfillmentCenterIdentifier/_wcf:UniqueID" /></value>
								</Attribute>
							</attribute>
						</OrderItem>
					</xsl:for-each>
				</orderItems>
			</order>
		</test:cancelInventoryReservations>
	</xsl:template>
</xsl:stylesheet>
