<?xml version="1.0" encoding="UTF-8"?>

<!--
-------------------------------------------------------------------
 Licensed Materials - Property of IBM

 WebSphere Commerce

 (c) Copyright International Business Machines Corporation. 2009
     All rights reserved.

 US Government Users Restricted Rights - Use, duplication or
 disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

-------------------------------------------------------------------

---------------------------------------------------------------------
 The sample contained herein is provided to you "AS IS".

 It is furnished by IBM as a simple example and has not been
 thoroughly tested
 under all conditions.  IBM, therefore, cannot guarantee its
 reliability, serviceability or functionality.

 This sample may include the names of individuals, companies, brands
 and products in order to illustrate concepts as completely as
 possible.  All of these names
 are fictitious and any similarity to the names and addresses used by
 actual persons
 or business enterprises is entirely coincidental.
---------------------------------------------------------------------
-->

<xsl:stylesheet
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:datetime="http://exslt.org/dates-and-times"
		xmlns:mediationUtil="com.ibm.commerce.sample.mediation.util.MediationUtil"
		xmlns:oa="http://www.openapplications.org/oagis/9"
		xmlns:udt="http://www.openapplications.org/oagis/9/unqualifieddatatypes/1.1"
		xmlns:_wcf="http://www.ibm.com/xmlns/prod/commerce/9/foundation"
		xmlns:_sto="http://www.ibm.com/xmlns/prod/commerce/9/store"
		xmlns:_inv="http://www.ibm.com/xmlns/prod/commerce/9/inventory"
		xmlns:_ord="http://www.ibm.com/xmlns/prod/commerce/9/order"
		xmlns:test="http://test" exclude-result-prefixes="xalan oa udt _wcf _sto _inv _ord"
		version="1.0">
	<xsl:output method="xml" encoding="UTF-8" indent="yes" xalan:indent-amount="2" />
	<xsl:strip-space elements="*" />
	<xalan:component prefix="mediationUtil" functions="xpathKey accessProfiles controlParameterValues xpathParameterValues parse serialize">
		<xalan:script lang="javaclass" src="xalan://com.ibm.commerce.foundation.mediation.util.MediationUtil" />
	</xalan:component>
	<xsl:template name="BodyToBody">
		<xsl:param name="body" />
		<xsl:variable name="xpath" select="$body/_inv:GetInventoryAvailability/_inv:DataArea/oa:Get/oa:Expression/text()" />
		<xsl:variable name="selectionCriteria" select="mediationUtil:selectionCriteria($xpath)" />
		<xsl:variable name="xpathKey" select="mediationUtil:xpathKey($selectionCriteria)" />
		<test:getInventory>
			<skuArray>
				<xsl:for-each select="mediationUtil:xpathParameterValues($selectionCriteria, 'PartNumber.1')">
					<string><xsl:value-of select="." /></string>
				</xsl:for-each>
			</skuArray>
			<ffmcIdArray>
				<xsl:for-each select="mediationUtil:xpathParameterValues($selectionCriteria, 'NameIdentifier.1')">
					<string><xsl:value-of select="." /> Home</string>
				</xsl:for-each>
				<xsl:for-each select="mediationUtil:xpathParameterValues($selectionCriteria, 'ExternalIdentifier.1')">
					<string><xsl:value-of select="." /></string>
				</xsl:for-each>
			</ffmcIdArray>
		</test:getInventory>
	</xsl:template>
</xsl:stylesheet>
