package com.mycompany.commerce.soitutorialstore.facade.server.commands;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2009
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import com.ibm.commerce.beans.DataBeanManager;
import com.ibm.commerce.common.beans.StoreDataBean;
import com.ibm.commerce.foundation.client.util.oagis.RelationalExpression;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.util.oagis.SelectionCriteriaMapper;

/**
 * This class fetches TutorialStore according to the unique ID.
 * This default implementation returns an empty list of TutorialStore .
 */
public class FetchTutorialStoreByIdCmdImpl 
	extends FetchTutorialStoreBaseCmdImpl 
	implements FetchTutorialStoreCmd {

	private static final String CLASSNAME = FetchTutorialStoreByIdCmdImpl.class.getName();
	private static final Logger LOGGER = LoggingHelper.getLogger(FetchTutorialStoreByIdCmdImpl.class);
	private static final String UNIQUE_ID_1 = "UniqueID.1";

	/**
	 * Creates an instance of the fetch TutorialStore by unique ID command.
	 */
	public FetchTutorialStoreByIdCmdImpl() {
		super();
	}
	
	/**
	 * This method executes the get expression.  
	 * This implementation returns an empty show response and list.
	 * @throws Exception	The exception encountered in this method.
	 * @see com.ibm.websphere.command.TargetableCommand#performExecute()
	 */
	public void performExecute() throws Exception {
		final String METHODNAME = "performExecute()";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
		
		if (LoggingHelper.isTraceEnabled(LOGGER)) {
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "selection expression : " + getSearchExpression());
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "get verb : " + getGet());
		} 
					
		java.util.List tutorialstores = new java.util.ArrayList();
		
		// Retrieve the appropriate databean using the ID and add them to the list "tutorialstores".
		SelectionCriteriaMapper selectionCriteria = new SelectionCriteriaMapper(getGet().getExpression());
		Map<String, RelationalExpression> mapQueryParameters = selectionCriteria.getXPathParameters();

		RelationalExpression expression = mapQueryParameters.get(UNIQUE_ID_1);
		List storeIds = expression.getValues();
		String storeId = (String) storeIds.get(0);

		StoreDataBean storeDataBean = new StoreDataBean();
		storeDataBean.setStoreId(storeId);
		DataBeanManager.activate(storeDataBean);

		tutorialstores.add(storeDataBean);
		
		setTutorialStores(tutorialstores);
		setShow(com.ibm.commerce.oagis9.datatypes.Oagis9Factory.eINSTANCE.createShowType());				
				
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

}
