package com.mycompany.commerce.soitutorialstore.facade.server.commands;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2009
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.logging.Logger;

import com.ibm.commerce.common.beans.StoreDataBean;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;

/**
 * The implementation of the fetch all TutorialStore command.
 * This default implementation returns an empty list of TutorialStore .
 */
public class FetchAllTutorialStoreCmdImpl 
	extends FetchTutorialStoreBaseCmdImpl 
	implements FetchTutorialStoreCmd {

	private static final String CLASSNAME = FetchAllTutorialStoreCmdImpl.class.getName();
	private static final Logger LOGGER = LoggingHelper.getLogger(FetchAllTutorialStoreCmdImpl.class);

	/**
	 * Creates an instance of the fetch TutorialStore command.
	 */
	public FetchAllTutorialStoreCmdImpl() {
		super();
	}
	/**
	 * This method executes the get expression.  
	 * This implementation returns an empty show response and list.
	 * @throws Exception	The exception encountered in this method.
	 * @see com.ibm.websphere.command.TargetableCommand#performExecute()
	 */
	public void performExecute() throws Exception {		
		final String METHODNAME = "performExecute()";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
		
		if (LoggingHelper.isTraceEnabled(LOGGER)) {
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "selection expression : " + getSearchExpression());
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "get verb : " + getGet());
		}
		
		java.util.List tutorialstores = new java.util.ArrayList();
				
		StoreDataBean storeDataBean = new StoreDataBean();
		tutorialstores.addAll(storeDataBean.findAllStores());
		
		setTutorialStores(tutorialstores);
		setShow(com.ibm.commerce.oagis9.datatypes.Oagis9Factory.eINSTANCE.createShowType());		

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, "getTutorialStores(): " + getTutorialStores());
		}
		
	}

}
