package com.mycompany.commerce.soitutorialstore.facade.server.commands;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2009
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */


import com.ibm.commerce.common.beans.StoreDataBean;
import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.StoreExternalIdentifierType;
import com.ibm.commerce.foundation.common.datatypes.StoreIdentifierType;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.TutorialStoreType;

/**
 * The implementation of the compose TutorialStore summary command.
 * This implementation returns an empty list of TutorialStore .
 */
public class ComposeTutorialStoreSummaryCmdImpl extends ComposeTutorialStoreBaseCmdImpl {

	private static final String CLASSNAME = ComposeTutorialStoreSummaryCmdImpl.class.getName();
	private static final java.util.logging.Logger LOGGER = LoggingHelper.getLogger(ComposeTutorialStoreSummaryCmdImpl.class);

	/**
	 * The constructor of ComposeTutorialStoreSummaryCmdImpl
	 */	
	public ComposeTutorialStoreSummaryCmdImpl() {
		super();
	}

	/**
	 * This method executes the get expression.  
	 * This implementation returns an empty show response and list.
 	 * @throws Exception	The exception encountered in this method.
	 * @see com.ibm.websphere.command.TargetableCommand#performExecute()
	 */
	public void performExecute() throws Exception {
		final String METHODNAME = "performExecute()";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
		
		if (LoggingHelper.isTraceEnabled(LOGGER)) {
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "get expression : " + getSearchExpression());
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "get verb : " + getGet());
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "tutorialstores : " + getTutorialStores());
		}
	
		java.util.List tutorialStoreTypeList = new java.util.ArrayList();
		
		TutorialStoreType aTutorialStore = getSOITutorialStoreFactory().eINSTANCE.createTutorialStoreType();
		tutorialStoreTypeList.add(aTutorialStore);
		
		StoreDataBean storeDataBean = getTutorialStoreDataBean();

		// Internal Identifier
		StoreIdentifierType storeIdentifier = CommerceFoundationFactory.eINSTANCE.createStoreIdentifierType();
		storeIdentifier.setUniqueID(storeDataBean.getStoreEntityId());
		
		// External Identifier
		StoreExternalIdentifierType storeExternalIdentifier = CommerceFoundationFactory.eINSTANCE.createStoreExternalIdentifierType();
		storeExternalIdentifier.setNameIdentifier(storeDataBean.getIdentifier());
		storeExternalIdentifier.setOwnerID(storeDataBean.getOwner().toString());
		storeIdentifier.setExternalIdentifier(storeExternalIdentifier);
		
		aTutorialStore.setStoreIdentifier(storeIdentifier);
		
		// Populate the result list with the newly build nouns.
		setTutorialStores(tutorialStoreTypeList);
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}

}
