package com.mycompany.commerce.soitutorialstore.facade.server.commands;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2009
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.Iterator;
import java.util.List;

import com.ibm.commerce.context.globalization.GlobalizationContext;
import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.command.CommandFactory;
import com.ibm.commerce.foundation.server.command.GenericCommandKeyImpl;
import com.ibm.commerce.foundation.server.services.businesscontext.ContextService;
import com.ibm.commerce.foundation.server.services.businesscontext.ContextServiceFactory;
import com.mycompany.commerce.soitutorialstore.facade.SOITutorialStoreFacadeConstants;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.InventorySystemType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.StoreCategoryType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.StoreStateType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.TutorialStoreType;

/**
 * The implementation of the compose TutorialStore details command.
 * This implementation returns an empty list of TutorialStore .
 */
public class ComposeTutorialStoreDetailsCmdImpl extends ComposeTutorialStoreBaseCmdImpl {


	private static final String CLASSNAME = ComposeTutorialStoreDetailsCmdImpl.class.getName();
	private static final java.util.logging.Logger LOGGER = LoggingHelper.getLogger(ComposeTutorialStoreDetailsCmdImpl.class);
	private ComposeTutorialStoreCmd iCommand = null;

	/**
	 * The constructor of ComposeTutorialStoreDetailsCmdImpl
	 */	
	public ComposeTutorialStoreDetailsCmdImpl() {
		super();
		// Create the ComposeTutorialStore details command.  This command will call the ComposeTutorialStoreSummary command and then add additional data.
		iCommand = (ComposeTutorialStoreCmd) CommandFactory.getInstance().createCommand(new GenericCommandKeyImpl(ComposeTutorialStoreCmd.class.getName(),SOITutorialStoreFacadeConstants.ACCESS_PROFILE_SUMMARY_INFORMATION));
	}

	/**
	 * This method executes the get expression.  
	 * This implementation returns an empty show response and list.
 	 * @throws Exception	The exception encountered in this method.
	 * @see com.ibm.websphere.command.TargetableCommand#performExecute()
	 */
	public void performExecute() throws Exception {
		final String METHODNAME = "performExecute()";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
		
		if (LoggingHelper.isTraceEnabled(LOGGER)) {
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "get expression : " + getSearchExpression());
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "get verb : " + getGet());
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "tutorialstores : " + getTutorialStores());
		}
		
		// Call the ComposeTutorialStoreSummary command.
		iCommand.setTutorialStores(getTutorialStores());
		iCommand.setGet(getGet());
		iCommand.setSearchExpression(getSearchExpression());
		iCommand.setTutorialStoreDataBean(getTutorialStoreDataBean());
		iCommand.execute();
		
		List tutorialStoreList = iCommand.getTutorialStores();
		if (LoggingHelper.isTraceEnabled(LOGGER)) {
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "getTutorialStores after calling the summary command: " + tutorialStoreList);
		}
		
		Iterator iter = tutorialStoreList.iterator();
		while (iter.hasNext()) {
			TutorialStoreType aTutorialStore = (TutorialStoreType) iter.next();
			aTutorialStore.setStorePath(createStorePath());
			aTutorialStore.setStoreState(createStoreState());
			aTutorialStore.setStoreCategory(createStoreCategory());
			aTutorialStore.setStoreDescription(createStoreDescription());
			aTutorialStore.setInventorySystem(createInventorySystem());
		}
		
		// Populate the result list with the newly build nouns.
		setTutorialStores(tutorialStoreList);

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}
	
	/**
	 * This method populates the store path for the TutorialStore noun.
	 * @return String The store path for the TutorialStore noun.
	 */
	protected String createStorePath() {
		
		final String METHODNAME = "createStorePath()";
		String storePath = null;
		
		try {
			storePath = getTutorialStoreDataBean().getDirectory();
		} catch (Exception e) {
			LOGGER.throwing(CLASSNAME,METHODNAME,e);
		}
		return storePath;
	}
	
	/**
	 * This method populates the StoreState for the TutorialStore noun.
	 * @return StoreStateType The store status for the TutorialStore noun (open, closed, or suspended).
	 */
	protected StoreStateType createStoreState() {
		
		final String METHODNAME = "createStoreState()";
		StoreStateType storeState = null;
		
		try {
			switch (Integer.parseInt(getTutorialStoreDataBean().getStatus())) {
				case 0: storeState = StoreStateType.CLOSED_LITERAL; break;
				case 1: storeState = StoreStateType.OPEN_LITERAL; break;
				case -1: storeState = StoreStateType.SUSPENDED_LITERAL; break;			
			}
		} catch (Exception e) {
			LOGGER.throwing(CLASSNAME,METHODNAME,e);
		}
		
		return storeState;	
	}
	
	/**
	 * This method populates the StoreCategory for the TutorialStore noun.
	 * @return StoreCategoryType The store category for the TutorialStore noun (B2B, B2C, etc).
	 */
	protected StoreCategoryType createStoreCategory() {
		final String METHODNAME = "createStoreCategory()";
		StoreCategoryType storeCategory = null;
		String storeType = null;
		
		try {
			storeType = getTutorialStoreDataBean().getStoreType();
		} catch (Exception e) {
			LOGGER.throwing(CLASSNAME, METHODNAME,e);
		}
		
		if (storeType != null) {
			if (storeType.equals("B2C")){storeCategory = StoreCategoryType.B2C_LITERAL;}
			if (storeType.equals("B2B")){storeCategory = StoreCategoryType.B2B_LITERAL;}
			if (storeType.equals("CHS")){storeCategory = StoreCategoryType.CHS_LITERAL;}
			if (storeType.equals("CPS")){storeCategory = StoreCategoryType.CPS_LITERAL;}
			if (storeType.equals("RHS")){storeCategory = StoreCategoryType.RHS_LITERAL;}
			if (storeType.equals("BRH")){storeCategory = StoreCategoryType.BRH_LITERAL;}
			if (storeType.equals("RPS")){storeCategory = StoreCategoryType.RPS_LITERAL;}
			if (storeType.equals("BRP")){storeCategory = StoreCategoryType.BRP_LITERAL;}
			if (storeType.equals("DPS")){storeCategory = StoreCategoryType.DPS_LITERAL;}
			if (storeType.equals("DPX")){storeCategory = StoreCategoryType.DPX_LITERAL;}
			if (storeType.equals("SCP")){storeCategory = StoreCategoryType.SCP_LITERAL;}
			if (storeType.equals("SPS")){storeCategory = StoreCategoryType.SPS_LITERAL;}
			if (storeType.equals("SHS")){storeCategory = StoreCategoryType.SHS_LITERAL;}
			if (storeType.equals("HCP")){storeCategory = StoreCategoryType.HCP_LITERAL;}
			if (storeType.equals("PBS")){storeCategory = StoreCategoryType.PBS_LITERAL;}
			if (storeType.equals("MHS")){storeCategory = StoreCategoryType.MHS_LITERAL;}
			if (storeType.equals("BMH")){storeCategory = StoreCategoryType.BMH_LITERAL;}
			if (storeType.equals("MPS")){storeCategory = StoreCategoryType.MPS_LITERAL;}
			if (storeType.equals("BMP")){storeCategory = StoreCategoryType.BMP_LITERAL;}
		}
		
		return storeCategory;
	}
	
	/**
	 * This method populates the inventory system for the TutorialStore noun.	 * 
	 * @return String The inventory system of the TutorialStore noun (ATP, Non-ATP, etc).
	 */
	protected InventorySystemType createInventorySystem() {
		final String METHODNAME = "createInventorySystem()";
		InventorySystemType inventorySystem = null;
		Short system = null;
						
		try {
			system = getTutorialStoreDataBean().getInventorySystem();
		} catch (Exception e) {
			LOGGER.throwing(CLASSNAME,METHODNAME,e);
		}
		
		if (system != null) {
			switch (system.shortValue()) {
				case -1: inventorySystem = InventorySystemType.ATP_LITERAL; break;
				case -2: inventorySystem = InventorySystemType.NON_ATP_LITERAL; break;
				case -3: inventorySystem = InventorySystemType.NONE_LITERAL;
			}
		}
		
		return inventorySystem;
	}
	
	/**
	 * This method populates the TutorialStore noun description.
	 * @return DescriptionType The description of the TutorialStore noun.
	 */
	protected DescriptionType createStoreDescription() {
		
		final String METHODNAME = "createStoreDescription()";
		DescriptionType description = CommerceFoundationFactory.eINSTANCE.createDescriptionType();
		
		ContextService bcs = ContextServiceFactory.getContextService();
		Integer storeLanguageId = null;
		
		try {
			// Default to the default language ID.
			storeLanguageId = new Integer(Integer.parseInt(getTutorialStoreDataBean().getLanguageId()));
			GlobalizationContext context = (GlobalizationContext) bcs.findContext(GlobalizationContext.CONTEXT_NAME);
			storeLanguageId = context.getLanguageId();
			description.setLanguage(storeLanguageId.toString());
			description.setValue(getTutorialStoreDataBean().getDescription(storeLanguageId).getDescription());
		} catch (Exception e) {
			LOGGER.throwing(CLASSNAME,METHODNAME,e);
		}
		
		return description;
	
	}

}
