package com.mycompany.commerce.soitutorialstore.facade.server.commands;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2009
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.List;

import com.ibm.commerce.common.beans.StoreDataBean;
import com.ibm.commerce.exception.ECException;
import com.ibm.commerce.foundation.server.command.bod.AbstractInsertMoreNounDataCmd;

/**
 * The command used to compose TutorialStore nouns based on a
 * get expression. 
 */
public interface ComposeTutorialStoreCmd extends AbstractInsertMoreNounDataCmd {

	
	/**
	 * This method sets the list of TutorialStores.
	 * @param tutorialstores The list of TutorialStores
	 */
	public void setTutorialStores(java.util.List tutorialstores);
	
	/**
	 * This method gets the list of TutorialStores.
	 * @return The list of TutorialStores
	 */
	public List getTutorialStores();
	
	
	/**
	 * Sets the data bean which is used to compose the TutorialStore.
	 * 
	 * @param aTutorialStoreDB <code>TutorialStoreDataBean</code>
	 * @throws ECException if an error occurs
	 */
	void setTutorialStoreDataBean(StoreDataBean aTutorialStoreDB);
}
