package com.mycompany.commerce.soitutorialstore.facade.server.commands;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2009
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.List;

import com.ibm.commerce.common.beans.StoreDataBean;
import com.ibm.commerce.foundation.server.command.bod.AbstractInsertMoreNounDataCmdImpl;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.SOITutorialStoreFactory;

/**
 * The base implementation of the compose TutorialStore command.
 * This implementation returns an empty list of TutorialStore .
 */
public abstract class ComposeTutorialStoreBaseCmdImpl extends AbstractInsertMoreNounDataCmdImpl
		implements ComposeTutorialStoreCmd {

	private static final String CLASSNAME = ComposeTutorialStoreBaseCmdImpl.class.getName();
	private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper.getLogger(ComposeTutorialStoreBaseCmdImpl.class);
	
	private StoreDataBean iStoreDataBean = null;
	
	/**
	 * The constructor of ComposeTutorialStoreBaseCmdImpl
	 */	
	public ComposeTutorialStoreBaseCmdImpl() {
		super();
	}

	/**
	 * This method sets the list of TutorialStores.
	 * @param tutorialstores The list of TutorialStores
	 */
	public void setTutorialStores(List tutorialstores) {
		setNouns(tutorialstores);
	}
	/**
	 * This method get the list of TutorialStores.
	 * @return List a list of tutorialstores 
	 */
	public List getTutorialStores() {
		return getNouns();
	}
	
	/**
	 * Getter method which returns the <code>SOITutorialStoreFactory</code>. 
	 * @return an object of type <code>SOITutorialStoreFactory</code>
	 */
	protected SOITutorialStoreFactory getSOITutorialStoreFactory() {
		return SOITutorialStoreFactory.eINSTANCE;
	}	
	
	/**
	 * This method sets the databean used to compose a TutorialStore noun.
	 */
	public void setTutorialStoreDataBean(StoreDataBean aTutorialStoreDataBean) {
		iStoreDataBean = aTutorialStoreDataBean;
	}
	
	/**
	 * This method gets the databean used to compose a TutorialStore noun.
	 * @return a <code>StoreDataBean</code>.
	 */
	protected StoreDataBean getTutorialStoreDataBean() {
		return iStoreDataBean;
	}
	
	
	// TODO: Implement common methods which are shared by different compose commands if any
	
}
