package com.mycompany.commerce.soitutorialstore.facade.server.commands;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2009
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.Iterator;
import java.util.List;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.command.CommandFactory;
import com.ibm.commerce.foundation.server.command.GenericCommandKeyImpl;
import com.mycompany.commerce.soitutorialstore.facade.SOITutorialStoreFacadeConstants;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.FulfillmentCenterIdentifierType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.FulfillmentCentersType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.SOITutorialStoreFactory;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.SupportedCurrenciesType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.SupportedLanguagesType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.TutorialStoreType;

/**
 * The implementation of the compose TutorialStore all command.
 * This implementation returns an empty list of TutorialStore .
 */
public class ComposeTutorialStoreAllCmdImpl extends ComposeTutorialStoreBaseCmdImpl {

	private static final String CLASSNAME = ComposeTutorialStoreAllCmdImpl.class.getName();
	private static final java.util.logging.Logger LOGGER = LoggingHelper.getLogger(ComposeTutorialStoreAllCmdImpl.class);
	private ComposeTutorialStoreCmd iCommand = null;

	/**
	 * The constructor of ComposeTutorialStoreAllCmdImpl
	 */	
	public ComposeTutorialStoreAllCmdImpl() {
		super();
		// Create the ComposeTutorialStore detail command.  This command will call the ComposeTutorialStoreDetail command and then add additional data.
		iCommand = (ComposeTutorialStoreCmd) CommandFactory.getInstance().createCommand(new GenericCommandKeyImpl(ComposeTutorialStoreCmd.class.getName(),SOITutorialStoreFacadeConstants.ACCESS_PROFILE_DETAILS_INFORMATION));
	}

	/**
	 * This method executes the get expression.  
	 * This implementation returns an empty show response and list.
 	 * @throws Exception	The exception encountered in this method.
	 * @see com.ibm.websphere.command.TargetableCommand#performExecute()
	 */
	public void performExecute() throws Exception {
		final String METHODNAME = "performExecute()";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
		
		if (LoggingHelper.isTraceEnabled(LOGGER)) {
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "get expression : " + getSearchExpression());
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "get verb : " + getGet());
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "tutorialstores : " + getTutorialStores());
		}
		
		// Call the ComposeTutorialStoreDetail command.
		iCommand.setTutorialStores(getTutorialStores());
		iCommand.setGet(getGet());
		iCommand.setSearchExpression(getSearchExpression());
		iCommand.setTutorialStoreDataBean(getTutorialStoreDataBean());
		iCommand.execute();
		
		List tutorialStoreList = iCommand.getTutorialStores();
		if (LoggingHelper.isTraceEnabled(LOGGER)) {
			LOGGER.logp(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
					CLASSNAME, METHODNAME, "getTutorialStores after calling the detail command: " + tutorialStoreList);
		}

		Iterator iter = tutorialStoreList.iterator();
		while (iter.hasNext()) {
			TutorialStoreType aTutorialStore = (TutorialStoreType) iter.next();
			aTutorialStore.setSupportedCurrencies(createSupportedCurrencies());
			aTutorialStore.setSupportedLanguages(createSupportedLanguages());
			aTutorialStore.setFulfillmentCenters(createFulfillmentCenters());			
		}		
		
		// Populate the result list with the newly build nouns.
		setTutorialStores(tutorialStoreList);
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}
	
	/**
	 * This method populates the supported currencies for the TutorialStore noun.
	 * @return SupportedCurrenciesType The supported currencies for the TutorialStore noun.
	 */
	protected SupportedCurrenciesType createSupportedCurrencies() {
		
		SupportedCurrenciesType supportedCurrencies = SOITutorialStoreFactory.eINSTANCE.createSupportedCurrenciesType();
		String currency = null;
		
		try {
			Integer[] languageIds = getTutorialStoreDataBean().getSupportedLanguageIds();
			
			if (languageIds.equals(null)) {
				languageIds[0] = Integer.getInteger(getTutorialStoreDataBean().getLanguageId());
			}
			
			for (int i=0; i<languageIds.length; i++) {
				currency = getTutorialStoreDataBean().getCurrency(languageIds[i]);
				if (!supportedCurrencies.getCurrency().contains(currency)) {
					supportedCurrencies.getCurrency().add(currency);
				}					
			}	
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return supportedCurrencies;
	}
	
	/**
	 * This method populates the supported languages for the TutorialStore noun.
	 * @return SupportedLanguagesType The supported languages for the TutorialStore noun.
	 */
	protected SupportedLanguagesType createSupportedLanguages() {
		
		SupportedLanguagesType supportedLanguages = SOITutorialStoreFactory.eINSTANCE.createSupportedLanguagesType();
		
		try {
			Integer[] languageIds = getTutorialStoreDataBean().getSupportedLanguageIds();
			
			if (languageIds.equals(null)) {
				languageIds[0] = Integer.getInteger(getTutorialStoreDataBean().getLanguageId());
			}
			
			if (!languageIds.equals(null)) {
				supportedLanguages.getLanguage().add(languageIds);			
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return supportedLanguages;
	}
	
	/**
	 * This method populates the fulfillment center for the TutorialStore noun.
	 * @return FulfillmentCentersType The fulfillment center for the TutorialStore noun.
	 */
	protected FulfillmentCentersType createFulfillmentCenters() {
		
		FulfillmentCentersType fulfillmentCenters = SOITutorialStoreFactory.eINSTANCE.createFulfillmentCentersType();
		FulfillmentCenterIdentifierType fulfillmentCenterIdentifier = SOITutorialStoreFactory.eINSTANCE.createFulfillmentCenterIdentifierType();
		
		try {
			fulfillmentCenterIdentifier.setUniqueID(getTutorialStoreDataBean().getFulfillmentCenterId());
			fulfillmentCenters.getFulfillmentCenterIdentifier().add(fulfillmentCenterIdentifier);			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return fulfillmentCenters;
	}

}
