
package com.mycompany.commerce.soitutorialstore.facade.server.commands; 

import com.ibm.commerce.command.ControllerCommand;
import com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd;
import com.ibm.commerce.oagis9.datatypes.AcknowledgeType;
import com.ibm.commerce.oagis9.datatypes.BusinessObjectDocumentType;
import com.ibm.commerce.oagis9.datatypes.ChangeStatusType;
import com.ibm.commerce.oagis9.datatypes.DescriptionType;
import com.ibm.commerce.oagis9.datatypes.Oagis9Factory;
import com.ibm.commerce.oagis9.datatypes.ResponseActionCriteriaType;
import com.ibm.websphere.command.CommandException;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.AcknowledgeTutorialStoreDataAreaType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.AcknowledgeTutorialStoreType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.SOITutorialStoreFactory;

/**
 * This command builds the TutorialStore acknowledge response to a process request if an error occurs.
 */
public class AcknowledgeTutorialStoreBuildErrorCmdImpl implements
		MessageMappingResponseCmd {

	private Exception iException = null;
	private AcknowledgeTutorialStoreType iAcknowledgeTutorialStore = null;
	
	/**
	 * Creates an instance of the acknowledge TutorialStore error response builder.
	 */
	public AcknowledgeTutorialStoreBuildErrorCmdImpl() {
		super();
	}
	
	/**
	 * This method sets the controller command used in the message mapping request.
	 * @param arg0 The controller command used in the message mapping request.
	 * @see com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd#setControllerCommand(com.ibm.commerce.command.ControllerCommand)
	 */
	public void setControllerCommand(ControllerCommand arg0) {
	}

	/** This method sets the exception (if any) that occurred during the process operation.
	 * @see com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd#setException(java.lang.Exception)
	 */
	public void setException(Exception arg0) {
		iException = arg0;
	}

	/** This method returns the acknowledge TutorialStore noun error response.
	 * @see com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd#getBusinessObjectDocument()
	 */
	public BusinessObjectDocumentType getBusinessObjectDocument() {
		return iAcknowledgeTutorialStore;
	}

	/** This method builds the acknowledge TutorialStore noun error response.
	 * @see com.ibm.websphere.command.Command#execute()
	 */
	public void execute() throws CommandException {
	
	iAcknowledgeTutorialStore = SOITutorialStoreFactory.eINSTANCE.createAcknowledgeTutorialStoreType();
	AcknowledgeType acknowledge = Oagis9Factory.eINSTANCE.createAcknowledgeType();
	AcknowledgeTutorialStoreDataAreaType acknowledgeDataArea = SOITutorialStoreFactory.eINSTANCE.createAcknowledgeTutorialStoreDataAreaType();        
	iAcknowledgeTutorialStore.setDataArea(acknowledgeDataArea);
	iAcknowledgeTutorialStore.getDataArea().setAcknowledge(acknowledge);

        ChangeStatusType changeStatus = Oagis9Factory.eINSTANCE.createChangeStatusType();
        DescriptionType description = Oagis9Factory.eINSTANCE.createDescriptionType();
        description.setValue(iException.getLocalizedMessage());
        changeStatus.setDescription(description);
     
        ResponseActionCriteriaType responseActionCriteria = Oagis9Factory.eINSTANCE.createResponseActionCriteriaType();
        acknowledge.getResponseCriteria().add(responseActionCriteria);
        responseActionCriteria.setChangeStatus(changeStatus);
           	   
	}

	/**
	 * This method returns whether the command has the get verb specified
	 * so it is ready to execute.
	 * @return Whether the command can execute or not.
	 * @see com.ibm.websphere.command.Command#isReadyToCallExecute()
	 */
	public boolean isReadyToCallExecute() {
		return (iException != null);
	}

	/**
	 * This method resets the instance variables so the command can be reused.
	 * @see com.ibm.websphere.command.Command#reset()
	 */
	public void reset() {
		iException = null;
		iAcknowledgeTutorialStore = null;
	}

}