
package com.mycompany.commerce.soitutorialstore.facade.server.commands;

/*
*-------------------------------------------------------------------
* Licensed Materials - Property of IBM
*
* WebSphere Commerce
*
* (c) Copyright International Business Machines Corporation.
* 2007
* All rights reserved.
*
* US Government Users Restricted Rights - Use, duplication or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*-------------------------------------------------------------------
*/ 

import com.ibm.commerce.command.ControllerCommand;
import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.StoreIdentifierType;
import com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd;
import com.ibm.commerce.oagis9.datatypes.AcknowledgeType;
import com.ibm.commerce.oagis9.datatypes.BusinessObjectDocumentType;
import com.ibm.commerce.oagis9.datatypes.Oagis9Factory;
import com.ibm.websphere.command.CommandException;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.AcknowledgeTutorialStoreDataAreaType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.AcknowledgeTutorialStoreType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.DocumentRoot;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.SOITutorialStoreFactory;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.TutorialStoreType;

/**
 * This command builds the TutorialStore acknowledge response to a process request.
 */
public class AcknowledgeTutorialStoreBuildCmdImpl implements MessageMappingResponseCmd {

	private ControllerCommand iControllerCommand = null;
	private AcknowledgeTutorialStoreType iAcknowledgeTutorialStoreType = null;
	private static final String CLASSNAME = AcknowledgeTutorialStoreBuildCmdImpl.class.getName();
	
	/**
	 * Creates an instance of the acknowledge TutorialStore response builder.
	 */
	public AcknowledgeTutorialStoreBuildCmdImpl() {
		super();
	}
	
	/**
	 * This method sets the controller command used in the message mapping request.
	 * @param arg0 The controller command used in the message mapping request.
	 * @see com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd#setControllerCommand(com.ibm.commerce.command.ControllerCommand)
	 */
	public void setControllerCommand(ControllerCommand arg0) {
		iControllerCommand = arg0;
	}

	/** This method sets the exception (if any) that occurred during the process operation.
	 * @see com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd#setException(java.lang.Exception)
	 */
	public void setException(Exception arg0) {
		// TODO Auto-generated method stub

	}

	/** This method returns the acknowledge TutorialStore noun response.
	 * @see com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd#getBusinessObjectDocument()
	 */
	public BusinessObjectDocumentType getBusinessObjectDocument() {
		return iAcknowledgeTutorialStoreType;
	}

	/** This method builds the acknowledge TutorialStore noun response.
	 * @see com.ibm.websphere.command.Command#execute()
	 */
	public void execute() throws CommandException {
		iAcknowledgeTutorialStoreType = SOITutorialStoreFactory.eINSTANCE.createAcknowledgeTutorialStoreType();
		DocumentRoot docRoot = SOITutorialStoreFactory.eINSTANCE.createDocumentRoot();
		docRoot.setAcknowledgeTutorialStore(iAcknowledgeTutorialStoreType);
		AcknowledgeTutorialStoreDataAreaType dataArea = SOITutorialStoreFactory.eINSTANCE.createAcknowledgeTutorialStoreDataAreaType();
		iAcknowledgeTutorialStoreType.setDataArea(dataArea);
		
		AcknowledgeType acknowledgeVerb = Oagis9Factory.eINSTANCE.createAcknowledgeType();
		dataArea.setAcknowledge(acknowledgeVerb);
		
		TutorialStoreType store = SOITutorialStoreFactory.eINSTANCE.createTutorialStoreType();
		dataArea.getTutorialStore().add(store);
		
		StoreIdentifierType storeIdentifier = CommerceFoundationFactory.eINSTANCE.createStoreIdentifierType();
		storeIdentifier.setUniqueID(iControllerCommand.getRequestProperties().getString("targetStoreId",null));
		store.setStoreIdentifier(storeIdentifier);

	}
	
	/**
	 * This method returns whether the command has the get verb specified
	 * so it is ready to execute.
	 * @return Whether the command can execute or not.
	 * @see com.ibm.websphere.command.Command#isReadyToCallExecute()
	 */
	public boolean isReadyToCallExecute() {
		return (iControllerCommand != null);
	}

	/**
	 * This method resets the instance variables so the command can be reused.
	 * @see com.ibm.websphere.command.Command#reset()
	 */
	public void reset() {
		iControllerCommand = null;
		iAcknowledgeTutorialStoreType = null;

	}

}
