package com.mycompany.commerce.soitutorialstore.facade.server.commands;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2007, 2009
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import com.ibm.commerce.command.ControllerCommand;
import com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd;
import com.ibm.commerce.oagis9.datatypes.BusinessObjectDocumentType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.AcknowledgeTutorialStoreType;
import com.mycompany.commerce.soitutorialstore.facade.datatypes.SOITutorialStoreFactory;

/**
 * The base implementation of the TutorialStore acknowledge command.
 */
public abstract class AcknowledgeTutorialStoreBaseCmdImpl implements
		MessageMappingResponseCmd {

	protected ControllerCommand iControllerCommand = null;
	protected Exception iException = null;
	protected AcknowledgeTutorialStoreType iAcknowledgeTutorialStoreType = null;

	private static final String CLASSNAME = AcknowledgeTutorialStoreBaseCmdImpl.class
			.getName();

	/**
	 * Creates an instance of the acknowledge TutorialStore response builder.
	 */
	public AcknowledgeTutorialStoreBaseCmdImpl() {
		super();
	}

	/**
	 * This method sets the controller command used in the message mapping
	 * request.
	 * 
	 * @param arg0
	 *            The controller command used in the message mapping request.
	 * @see com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd#setControllerCommand(com.ibm.commerce.command.ControllerCommand)
	 */
	public void setControllerCommand(ControllerCommand controllerCommand) {
		iControllerCommand = controllerCommand;
	}

	/**
	 * This method sets the exception (if any) that occurred during the process
	 * operation.
	 * 
	 * @see com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd#setException(java.lang.Exception)
	 */
	public void setException(Exception exception) {
		iException = exception;
	}

	/**
	 * Getter method which returns the <code>TutorialStoreFactory</code>.
	 * 
	 * @return an object of type <code>TutorialStoreFactory</code>
	 */
	protected SOITutorialStoreFactory getTutorialStoreFactory() {
		return SOITutorialStoreFactory.eINSTANCE;
	}

	/**
	 * This method returns the acknowledge TutorialStore noun response.
	 * 
	 * @see com.ibm.commerce.foundation.server.command.soi.MessageMappingResponseCmd#getBusinessObjectDocument()
	 */
	public BusinessObjectDocumentType getBusinessObjectDocument() {
		return iAcknowledgeTutorialStoreType;
	}

	/**
	 * This method returns whether the command has the get verb specified so it
	 * is ready to execute.
	 * 
	 * @return Whether the command can execute or not.
	 * @see com.ibm.websphere.command.Command#isReadyToCallExecute()
	 */
	public boolean isReadyToCallExecute() {
		return (iControllerCommand != null);
	}

	/**
	 * This method resets the instance variables so the command can be reused.
	 * 
	 * @see com.ibm.websphere.command.Command#reset()
	 */
	public void reset() {
		iControllerCommand = null;
		iException = null;
		iAcknowledgeTutorialStoreType = null;
	}
}
