﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Threading.Tasks;
using Newtonsoft.Json;

namespace ASE_XML_IssuesReport
{
    class ASMHelper
    {
        HttpClient client = null;
        string asc_xsrf_token;
        string baseUrl;

        public ASMHelper() : this(null)
        {
            
        }

        public ASMHelper(HttpClient existing_client)
        {
            if (client == null)
            {
                client = new HttpClient();
            }
            else
            {
                client = existing_client;
            }
        }

        public UriHostNameType CheckBaseUrlHost(String baseUrlStr)
        {
            return Uri.CheckHostName(new Uri(baseUrlStr).Host);
        }

        public void TrustAllCerts(Boolean state)
        {
            if (state)
            {
                if (ServicePointManager.ServerCertificateValidationCallback == null)
                    ServicePointManager.ServerCertificateValidationCallback +=
                    (sender, cert, chain, sslPolicyErrors) => true;
            }
            else
            {
                ServicePointManager.ServerCertificateValidationCallback = null;
            }
        }

        public class LoginDetails
        {
            public string userId { get; set; }
            public string password { get; set; }
            public string featureKey { get; set; }
        }
        public class LoginResponse
        {
            public bool loggedIn { get; set; }
            public string sessionId { get; set; }
            public string version { get; set; }
            public bool isDASTScanningEnabled { get; set; }
        }
        public async Task<HttpResponseMessage> Login(String baseUrlStr, String username, String password)
        {
            StringContent content;
            HttpResponseMessage resp = null;
            UriBuilder uri;
            LoginDetails loginDetails = new LoginDetails();
            LoginResponse loginResponse = new LoginResponse();


            this.baseUrl = VirtualPathUtility.AppendTrailingSlash(baseUrlStr);
            uri = new UriBuilder(new Uri(baseUrl + "api/login"));
            uri.Port = 9443;

            try
            {
                if(!TimeSpan.Equals(client.Timeout,new TimeSpan(0,12,0)))
                    client.Timeout = new TimeSpan(0, 12, 0);
                

                loginDetails.userId = username;
                loginDetails.password = password;
                loginDetails.featureKey = "AppScanEnterpriseUser";

                content = new StringContent(JsonConvert.SerializeObject(loginDetails, Formatting.Indented));
                content.Headers.ContentType = new System.Net.Http.Headers.MediaTypeHeaderValue("application/json");


                System.Diagnostics.Debug.Write("Making login request to " + uri + "\n");

                resp = await client.PostAsync(uri.Uri, content);
                System.Diagnostics.Debug.Write("Response code: " + resp.StatusCode + "\n");
                loginResponse = JsonConvert.DeserializeObject<LoginResponse>(resp.Content.ReadAsStringAsync().Result);
                asc_xsrf_token = loginResponse.sessionId;

                System.Diagnostics.Debug.Write("Response: " + JsonConvert.SerializeObject(loginResponse, Formatting.Indented) + "\n");

            }
            catch (Exception e)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += uri.ToString() + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (e.InnerException != null)
                {
                    exceptionMessage += e.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += e.Message + Environment.NewLine;
                    exceptionMessage += e.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;


                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);
            }

            return resp;

        }

        public async Task<HttpResponseMessage> Logout()
        {
            HttpResponseMessage resp = null;

            UriBuilder uri = new UriBuilder(new Uri(baseUrl + "api/logout"));
            uri.Port = 9443;

            try
            {
                System.Diagnostics.Debug.Write("Making logoff request to " + uri + "\n");
                resp = await client.GetAsync(uri.Uri);
                System.Diagnostics.Debug.Write("Response code: " + resp.StatusCode + "\n");
                System.Diagnostics.Debug.Write("Response: " + resp.Content.ReadAsStringAsync().Result + "\n");
            }
            catch (Exception e)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += uri.ToString() + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (e.InnerException != null)
                {
                    exceptionMessage += e.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += e.Message + Environment.NewLine;
                    exceptionMessage += e.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;


                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);
            }

            return resp;

        }

        public class SecurityReportOption
        {
            public ReportOptionConfig config { get; set; } = new ReportOptionConfig();
            public ReportOptionLayout layout { get; set; } = new ReportOptionLayout();
            public string reportFileType { get; set; } = "XML";
            //public string[] issueIdsAndQueries { get; set; } = new string[] { "" };//{"severity=\"high\"","severity=\"medium\"","};
            public string[] issueIdsAndQueries { get; set; } = new string[] { "severity=high","severity=medium","status=open","status=new","status=reopened" };

        }

        public class ReportOptionConfig
        {
            public bool executiveSummaryIncluded { get; set; } = true;
            public bool advisoriesIncluded { get; set; } = true;
            public bool pdfPageBreakOnIssue { get; set; } = false;
            public bool sortByURL { get; set; } = false;
            public ReportOptionAttributeConfig applicationAttributeConfig { get; set; } = new ReportOptionAttributeConfig();
            public ReportOptionIssuesConfig issueConfig { get; set; } = new ReportOptionIssuesConfig();
        }
                
        public class ReportOptionAttributeConfig
        {
            public bool showEmptyValues { get; set; } = false;
            public string[] attributeLookups { get; set; } = new string[] { "" };
        }

        public class ReportOptionIssuesConfig
        {
            public bool includeAdditionalInfo { get; set; } = true;
            public ReportOptionIssueVariantConfig variantConfig { get; set; } = new ReportOptionIssueVariantConfig();
            public ReportOptionAttributeConfig issueAttributeConfig { get; set; } = new ReportOptionAttributeConfig();
        }

        public class ReportOptionIssueVariantConfig {
            public int variantLimit { get; set; } = 1;
            public bool requestResponseIncluded { get; set; } = true;
            public bool differencesIncluded { get; set; } = true;
        }

        public class ReportOptionLayout
        {
            public ReportOptionLayoutCoverPage reportOptionLayoutCoverPage { get; set; } = new ReportOptionLayoutCoverPage();
            public ReportOptionLayoutBody reportOptionLayoutBody { get; set; } = new ReportOptionLayoutBody();
            public bool includeTableOfContents { get; set; } = false;
        }

        public class ReportOptionLayoutCoverPage
        {
            public string companyLogo { get; set; } = "";
            public string additionalLogo { get; set; } = "";
            public bool includeDate { get; set; } = false;
            public bool includeReportType { get; set; } = false;
            public string reportTitle { get; set; } = "";
            public string description { get; set; } = "";
        }

        public class ReportOptionLayoutBody
        {
            public string header { get; set; } = "";
            public string footer { get; set; } = "";
        }
       

        public async Task<HttpResponseMessage> GetSecurityDetailsReport(int appNum)
        {
            StringContent content;
            HttpResponseMessage resp = null;
            UriBuilder uri = new UriBuilder(new Uri(baseUrl + "api/issues/reports/securitydetails"));
            uri.Port = 9443;
            uri.Query = "appId=" + appNum.ToString();
            System.Diagnostics.Debug.Write("URI: "+uri.ToString()+"\n");

            try
            {
                content = new StringContent(JsonConvert.SerializeObject(new SecurityReportOption(), Formatting.Indented));
                content.Headers.ContentType = new System.Net.Http.Headers.MediaTypeHeaderValue("application/json");
                client.DefaultRequestHeaders.Add("asc_xsrf_token", asc_xsrf_token);
                
                System.Diagnostics.Debug.Write("Making Report call for App Num " + appNum.ToString() + "\n");
                resp = await client.PostAsync(uri.Uri,content);
                System.Diagnostics.Debug.Write("Response code: " + resp.StatusCode + "\n");
                System.Diagnostics.Debug.Write("Response size: " + resp.Content.ReadAsStringAsync().Result.Length + "\n");
            }
            catch (Exception e)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += uri.ToString() + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (e.InnerException != null)
                {
                    exceptionMessage += e.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += e.Message + Environment.NewLine;
                    exceptionMessage += e.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;


                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);
            }
            return resp;
        }

        public async Task<HttpResponseMessage> GetReportStatus(Uri uri)
        {
            HttpResponseMessage resp = null;

            try
            {
                System.Diagnostics.Debug.Write("Requesting report status for " + uri + "\n");
                
                resp = await client.GetAsync(uri);
                System.Diagnostics.Debug.Write("Response code: " + resp.StatusCode + "\n");
                System.Diagnostics.Debug.Write("Response body: " + resp.Content.ReadAsStringAsync().Result + "\n");
                System.Diagnostics.Debug.Write("Response size: " + resp.Content.ReadAsStringAsync().Result.Length + "\n");
            }
            catch (Exception e)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += uri.ToString() + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (e.InnerException != null)
                {
                    exceptionMessage += e.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += e.Message + Environment.NewLine;
                    exceptionMessage += e.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;


                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);
            }
            return resp;
        }

        public async Task<HttpResponseMessage> GetReport(Uri uri)
        {
            HttpResponseMessage resp = null;

            try
            {
                System.Diagnostics.Debug.Write("Requesting report for " + uri + "\n");

                resp = await client.GetAsync(uri);
                System.Diagnostics.Debug.Write("Response code: " + resp.StatusCode + "\n");
                System.Diagnostics.Debug.Write("Response body: " + resp.Content.ReadAsStringAsync().Result + "\n");
                System.Diagnostics.Debug.Write("Response size: " + resp.Content.ReadAsStringAsync().Result.Length + "\n");
            }
            catch (Exception e)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += uri.ToString() + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (e.InnerException != null)
                {
                    exceptionMessage += e.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += e.Message + Environment.NewLine;
                    exceptionMessage += e.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;


                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);
            }
            return resp;
        }
    }
}
