// ====================================================
//
// Application Security Management REST API sample
// Last revision: 06/19/2015  (developed using AppScan Enteprise 9.0.2.1)
//
// This example demonstrates a way to identify 'Overdue Issues'
//
// Usage: from the command line 
//    C:\> cscript <current_filename>.js
// 
// ====================================================

// Include dependencies
eval(Include(".\\common_functions.js"));  // Common functions used by different samples
eval(Include(".\\_your_connection_info.js"));  // Your server connection information


if (REST_Login(yourServerName, yourServerPort, yourServerInstance, yourUserName, yourUserPassword))
{
	var activequery = ",status=new,status=open,status=reopened,status=inprogress,classification=definitive,classification=suspect";

	var now = new Date();
	var daysAgo = 3;
	var dateXDaysAgo = new Date(now - daysAgo * 24*60*60*1000);
	WScript.echo("List of apps with overdue issues (older than: "+getISODate(dateXDaysAgo)+")\n");
	
	query = "severity=critical,severity=high,DateCreated=1970-01-01\\," + getISODate(dateXDaysAgo);
	group = "Application Name";
	appquery = "businessimpact=highimpact";
	response = REST_GET("summaries/issues_v2", "query=" + encodeURIComponent(query + activequery) + "&group=" + encodeURIComponent(group) + "&appquery="+ encodeURIComponent(appquery));
	var aSummary = printIssueSummaries(response);
	
	if(aSummary != null && aSummary.length > 0) {
		var oAppItem = JSON.parse(aSummary[0]);
		
		WScript.echo("List of types of overdue issues in application: "+oAppItem.tagName+"\n");
		
		var appNamequery = ",Application Name="+oAppItem.tagName;
		query = "severity=critical,severity=high,DateCreated=1970-01-01\\," + getISODate(dateXDaysAgo);
		group = "Issue Type";
		response = REST_GET("summaries/issues_v2", "query=" + encodeURIComponent(query + activequery + appNamequery) + "&group=" + encodeURIComponent(group));
		aSummary = printIssueSummaries(response);
	}
	
	if(aSummary != null && aSummary.length > 0) {
		// Print the overdue issues of the first application with overdue issues
		var oItem = JSON.parse(aSummary[0]);
		
		WScript.echo("List of "+oItem.tagName+" overdue issues in application: "+oAppItem.tagName+"\n");
		
		appNamequery = ",Application Name="+oAppItem.tagName;
		issueTypequery = ",Issue Type="+oItem.tagName;
		activequery = ",status=new,status=open,status=reopened,status=inprogress,classification=definitive,classification=suspect";
		query = "severity=critical,severity=high,DateCreated=1970-01-01\\," + getISODate(dateXDaysAgo);
		response = REST_GET("issues", "query=" + encodeURIComponent(query + activequery + appNamequery + issueTypequery), "items=0-999");
		printIssueIds(response);
	}
	
	REST_Logout();
}

function getISODate(date) {
	return date.getFullYear() + "-" + (date.getMonth()+1) + "-" + date.getDate();
}


//=========================================================================
// [Name] : printIssueSummaries
// [Purpose] : Print out the response from issue summaries
//=========================================================================
function printIssueSummaries(response) {
	//
	// Process json response which looks like this...
	//
	//	[
	//		{
    //			"id": 29,
    //			"tagGroupId": 13,
    //			"tagId": 1041,
    //			"tagName": "Info",	<-- Use this
    //			"chartColor": "",
    //			"numMatch": 679		<-- And this
	//		},
	//		...
	//
	
    if(response != null) {
    	var array = getJSONArray(response);
		if(array.length == 0)
			WScript.echo("No issues with this criteria\n");
			
        for (i = 0; i < array.length; i++) {
            var oCount = JSON.parse(array[i]);
			WScript.echo(oCount.tagName + " : " + oCount.numMatch);
		}
		
		WScript.echo("\n");
		
		return array;
    }
	else return null;
}


function printIssueIds(response) {

    if(response != null) {
    	var aIssues = getJSONArray(response);
		if(aIssues.length == 0)
			WScript.echo("No issues with this criteria\n");
			
        for (i = 0; i < aIssues.length; i++) {
            var oCount = JSON.parse(aIssues[i]);
			WScript.echo("Overdue Issue: " + oCount.id);
		}
		
		WScript.echo("\n");
		
    }
}





/***********************************************************************************************************/
/***********************************************************************************************************/
//
//        Helper functions
//
/***********************************************************************************************************/
/***********************************************************************************************************/

//=========================================================================
// [Name] : <include()>
// [Purpose] : <Read a script file>
// [Out] :	<file content>
//=========================================================================
function Include(strFname) {
    var objFSO = new ActiveXObject("Scripting.FileSystemObject");
    var objTextFile = objFSO.OpenTextFile(strFname, 1);
    var sReadAll = objTextFile.ReadAll();
    objTextFile.Close();
    return sReadAll;
}
