// ====================================================
//
// Application Security Management REST API sample - Common Functions
// Last revision: 06/19/2015  (developed using AppScan Enteprise 9.0.2.1)
//
// This file contains functions re-used by the different samples
//
// Usage: This file is to be included from the actual samples
// 
// ====================================================

// Include javascript dependency
eval(Include(".\\3rdParty\\json2.js"));  // Download from: https://github.com/douglascrockford/JSON-js


//GLOBAL VARIABLES (used in the REST wrapper functions)
var xmlhttp;
var appServerUrl;
var xsrfToken;
var verboseLogs = false;



/***********************************************************************************************************/
/***********************************************************************************************************/
//
//        Other Helper functions
//
/***********************************************************************************************************/
/***********************************************************************************************************/

//=========================================================================
// 
// [Name] : <include()>
// 
// [Purpose] : <Read a script file>
//
// [Out] :	<file content>
//
//=========================================================================
function Include(strFname) {
    var objFSO = new ActiveXObject("Scripting.FileSystemObject");
    var objTextFile = objFSO.OpenTextFile(strFname, 1);
    //Read content of include file
    var sReadAll = objTextFile.ReadAll();
    //Close file, release FileSystemObject
    objTextFile.Close();
    return sReadAll;
}
//=========================================================================
// 
// [Name] : <REST_Login()>
// 
// [Purpose] : <Connect to ASE and get the necessary token to be used in subsequest REST API calls>
//
// [Out] :	<xsrfToken or false if logon failed.>
//
//=========================================================================
function REST_Login(sAppServerHost, sAppServerPort, sInstanceName, sUName, sUPW) {

    appServerUrl = "https://" + sAppServerHost + ":" + sAppServerPort + "/" + sInstanceName + "/api/";

    try {

        xmlhttp = new ActiveXObject("MSXML2.ServerXMLHTTP.6.0");
        SXH_SERVER_CERT_IGNORE_ALL_SERVER_ERRORS = 13056;
        xmlhttp.setOption(2) = SXH_SERVER_CERT_IGNORE_ALL_SERVER_ERRORS;

        var ascLoginURL = appServerUrl + "login";
        var response;
        var strUser = sUName.replace(/\\/g, "\\\\");
        var postdata = "{" +
						"\"userId\": \"" + strUser + "\"," +
						"\"password\": \"" + sUPW + "\"," +
						"\"featureKey\": \"AppScanServerInternal\"}";
        xmlhttp.open("POST", ascLoginURL, false);
        xmlhttp.setTimeouts(0, 0, 0, 0);
		xmlhttp.setRequestHeader("Accept", "application/json;opt=no-html-encoding");
        xmlhttp.setRequestHeader("Content-type", "application/json");
        xmlhttp.send(postdata);
        response = xmlhttp.responseText;

        //Check if the user is authorized before proceeding.
        if (xmlhttp.status == "401") {
            WScript.echo("Login failed!\n" + response);
            return false;
        }

        var strHeader = xmlhttp.getAllResponseHeaders();
		WScript.echo("Login succeeded!\n");
        xsrfToken = getAscXsrfToken(strHeader)
		
        return true;
    }
    catch (e) {
        WScript.echo("Logon failed!\nError code: " + e.description);
        return false;
    }
}
//=========================================================================
// 
// [Name] : <getAscXsrfToken>
// 
// [Purpose] : <Extract the asc_xsrf_token from the response header>
//
// [In] : <response header string (from a xmlhttp.getAllResponseHeaders(); call)>
//
// [Out] : <value of the asc_xsrf_token>
//
//
//=========================================================================
function getAscXsrfToken(strHeader) {
    var sPos = strHeader.search(/asc_session_id/i);
    strHeader = strHeader.substr(sPos);
    sPos = strHeader.search(/;/);
    strHeader = strHeader.substr(0, sPos);
    sPos = strHeader.search(/=/);
    strHeader = strHeader.substr(sPos + 1, strHeader.length - sPos - 1);
    return strHeader;
}
//=========================================================================
// 
// [Name] : <REST_Logout()>
// 
// [Purpose] : <Disconnect from ASE>
//
// [Out] :	<>
//
//=========================================================================
function REST_Logout() {

    LogoutURL = appServerUrl + "logout";
    xmlhttp.open("GET", LogoutURL, false);
    xmlhttp.setRequestHeader("Accept", "application/json;opt=no-html-encoding");
    xmlhttp.send();
    response = xmlhttp.responseText;

    if (xmlhttp.responseText != "") {
        WScript.echo("Response for logout: " + response);
    }
    else {
		WScript.echo("Logout succeeded");
    }
}

//=========================================================================
// 
// [Name] : <REST_GET()>
// 
// [Purpose] : <Simple REST API call using GET and query string>
//
// [Out] :	<response>
//
//=========================================================================
function REST_GET(api, queryString, rangeHeader) {

	var finalURL = appServerUrl + api + "?"+ queryString;
	
	if(verboseLogs)
		WScript.echo("URL: " + finalURL + "\n");
	
    xmlhttp.open("GET", finalURL, false);
    xmlhttp.setRequestHeader("Accept", "application/json;opt=no-html-encoding");
    xmlhttp.setRequestHeader("asc_xsrf_token", xsrfToken);
	if(rangeHeader != undefined) {
		xmlhttp.setRequestHeader("Range", rangeHeader);
	}
    xmlhttp.send();

    if (xmlhttp.status != 200) {
		WScript.echo("***HTTP Status Code: " + xmlhttp.status + "\n\n");
        return null;
    }
    else {
		return response = xmlhttp.responseText;
    }
}

//=========================================================================
// 
// [Name] : <getJSONArray>
// 
// [Purpose] : <Divides a listing of JSON objects into an array that can be iterated.>
//
// [Out] :	<An array of strings representing JSON objects>
//
//=========================================================================
function getJSONArray(response) {
    response = response.substr(1, response.length - 2);
    if (response.length < 3)
        return new Array();
    var aJsonObjects = response.split("},{");
    if (aJsonObjects.length > 1) {
        aJsonObjects[0] = aJsonObjects[0] + "}";
        for (i = 1; i < aJsonObjects.length - 1; i++)
            aJsonObjects[i] = "{" + aJsonObjects[i] + "}";
        aJsonObjects[i] = "{" + aJsonObjects[i];
    }
    return aJsonObjects;
}