// ====================================================
//
// Application Security Management REST API sample
// Last revision: 06/19/2015  (developed using AppScan Enteprise 9.0.2.1)
//
// This example shows how to login, get basic summary information about issues using application attributes as part of the query, and logout
//
// Usage: from the command line 
//    C:\> cscript <current_filename>.js
// 
// ====================================================

// Include dependencies
eval(Include(".\\common_functions.js"));  // Common functions used by different samples
eval(Include(".\\_your_connection_info.js"));  // Your server connection information


if (REST_Login(yourServerName, yourServerPort, yourServerInstance, yourUserName, yourUserPassword))
{
	var activequery = ",status=new,status=open,status=reopened,status=inprogress,classification=definitive,classification=suspect";
	
	WScript.echo("Number of active/open SAST Issues by Severity\n");
	query = "discoverymethod=SAST";
	group = "severity";
	appquery = "";
	response = REST_GET("summaries/issues_v2", "query=" + encodeURIComponent(query + activequery) + "&group=" + encodeURIComponent(group) + "&appquery=" + encodeURIComponent(appquery));
	printIssueSummaries(response);
	
	
	WScript.echo("Number of active/open DAST Issues by Severity for apps with high business impact\n");
	query = "discoverymethod=DAST";
	group = "severity";
	appquery = "businessimpact=highimpact";
	response = REST_GET("summaries/issues_v2", "query=" + encodeURIComponent(query + activequery) + "&group=" + encodeURIComponent(group) + "&appquery=" + encodeURIComponent(appquery));
	printIssueSummaries(response);

	
	WScript.echo("Number of active/open issues that have critical or high severity Issues by type for apps with high business impact\n");
	query = "severity=critical,severity=high";
	group = "issue type";
	appquery = "businessimpact=highimpact";
	response = REST_GET("summaries/issues_v2", "query=" + encodeURIComponent(query + activequery) + "&group=" + encodeURIComponent(group) + "&appquery=" + encodeURIComponent(appquery));
	printIssueSummaries(response);
	
	REST_Logout();
}


//=========================================================================
// [Name] : printIssueSummaries
// [Purpose] : Print out the response from issue summaries
//=========================================================================
function printIssueSummaries(response) {
	//
	// Process json response which looks like this...
	//
	//	[
	//		{
    //			"id": 29,
    //			"tagGroupId": 13,
    //			"tagId": 1041,
    //			"tagName": "Info",	<-- Use this
    //			"chartColor": "",
    //			"numMatch": 679		<-- And this
	//		},
	//		...
	//
	
    if(response != null) {
    	var aReturnedCounts = getJSONArray(response);
		if(aReturnedCounts.length == 0)
			WScript.echo("No issues with this criteria\n");
			
        for (i = 0; i < aReturnedCounts.length; i++) {
            var oCount = JSON.parse(aReturnedCounts[i]);
			WScript.echo(oCount.tagName + " : " + oCount.numMatch);
		}
		
		WScript.echo("\n");
    }
}






/***********************************************************************************************************/
/***********************************************************************************************************/
//
//        Helper functions
//
/***********************************************************************************************************/
/***********************************************************************************************************/

//=========================================================================
// [Name] : <include()>
// [Purpose] : <Read a script file>
// [Out] :	<file content>
//=========================================================================
function Include(strFname) {
    var objFSO = new ActiveXObject("Scripting.FileSystemObject");
    var objTextFile = objFSO.OpenTextFile(strFname, 1);
    var sReadAll = objTextFile.ReadAll();
    objTextFile.Close();
    return sReadAll;
}
