﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net.Http;
using Newtonsoft.Json;

namespace ASE_XML_IssuesReport
{
    public partial class IssuesReportASM : Form
    {
        ASMHelper asm = new ASE_XML_IssuesReport.ASMHelper();
        Boolean isLoggedIn = false;

        public IssuesReportASM()
        {
            InitializeComponent();
        }

        private async void cmdLogin_Click(object sender, EventArgs e)
        {
            HttpResponseMessage resp;
            resp = await login();
        }

        private async Task<HttpResponseMessage> login()
        {
            HttpResponseMessage resp;
            cmdLogin.Enabled = false;
            if (!isLoggedIn)
            {
                resp = await asm.Login(txtASEBaseURL.Text, txtUserName.Text, txtPassword.Text);
                if (resp.StatusCode == System.Net.HttpStatusCode.OK)
                {
                    cmdLogin.Text = "&Logout";
                    isLoggedIn = true;
                }
            }
            else
            {
                cmdLogin.Text = "&Login";
                resp = await asm.Logout();
                isLoggedIn = false;
            }
            cmdLogin.Enabled = true;

            return resp;
        }
        private async Task<HttpResponseMessage> checkAutoLoginAndLogin()
        {
            HttpResponseMessage resp;

            if (!isLoggedIn && chkAutoLogin.Checked)
            {
                resp = await login();
            } else
            {
                resp = null;
            }
            return resp;
        }
        Uri reportLocation;
        Uri reportStatusLocation;
        private async void cmdGetSecurityDetailsReport_Click(object sender, EventArgs e)
        {
            HttpResponseMessage resp;

            await checkAutoLoginAndLogin();

            resp = await asm.GetSecurityDetailsReport(Int32.Parse(txtAppID.Text));

            if (resp.StatusCode == System.Net.HttpStatusCode.Accepted)
            {
                System.Diagnostics.Debug.Write(resp.Headers.Location + "\n");
                reportStatusLocation = resp.Headers.Location;
            }
        }

        Boolean isCreated;
        private void cmdGetReportStatus_Click(object sender, EventArgs e)
        {
            if (!isLoggedIn)
            {
                System.Diagnostics.Debug.Write("Need to first login!");
                MessageBox.Show("Need to first login!","IssuesReportASM");

                return;
            }

            if (reportStatusLocation == null)
            {
                System.Diagnostics.Debug.Write("No Report Status Location" + "\n");
                MessageBox.Show("Need to request Security Details report first.", "IssuesReportASM");

                return;
            }

            if (cmdGetReportStatus.Text == "&Cancel") { 
                worker.CancelAsync();
            }  
            else
            {
                if (progressGetReportStatus.Style != ProgressBarStyle.Marquee)
                    progressGetReportStatus.Style = ProgressBarStyle.Marquee;

                txtStartTime.Text = DateTime.Now.ToString();

                worker.RunWorkerAsync();
                cmdGetReportStatus.Text = "&Cancel";
            }
        }

        private async void cmdSaveReport_Click(object sender, EventArgs e)
        {

            HttpResponseMessage resp;

            if (!isCreated)
            {
                MessageBox.Show("Report for Application ID " + txtAppID.Text + " has not been created yet", "IssuesReportASM");
            }
            else
            {

                if (reportLocation == null)
                {
                    System.Diagnostics.Debug.Write("No Report Location" + "\n");
                    return;
                }
                resp = await asm.GetReport(reportLocation);
                if (resp.StatusCode == System.Net.HttpStatusCode.OK)
                {
                    String reportFileName = "Report-"
                                            + txtAppID.Text + "-"
                                            + DateTime.Now.Date.Year.ToString() + "-"
                                            + DateTime.Now.Date.Month.ToString() + "-"
                                            + DateTime.Now.Date.Day.ToString() + ".zip";

                    System.IO.FileStream fs = new System.IO.FileStream(reportFileName, System.IO.FileMode.Create);
                    
                    await resp.Content.ReadAsStreamAsync().Result.CopyToAsync(fs);
                    fs.Close();
                    System.Diagnostics.Debug.Write("Report file [" + reportFileName + "] saved successfully");
                    MessageBox.Show("Report file [" + reportFileName + "] saved successfully","IssuesReportASM");
                }
            }
        }

        private void worker_DoWork(object sender, DoWorkEventArgs e)
        {
            bool done = false;
            int count = 0;

            while (!done)
            {
                if (worker.CancellationPending == true)
                {
                    e.Cancel = done = true;

                    break;
                }
                else
                {
                    if (count > 100)
                        count = 0;
                    else
                        count++;
                    worker.ReportProgress(count);

                    System.Threading.Thread.Sleep(1000);
                    if (isCreated == true)
                    {
                        done = true;
                    }
                    else
                    {
                        System.Threading.Thread.Sleep((Int32.Parse(txtPollTime.Text)*1000)-1000);
                    }
                }
            }
        }

        private async void worker_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            HttpResponseMessage resp;

            resp = await asm.GetReportStatus(reportStatusLocation);
            if (resp.StatusCode == System.Net.HttpStatusCode.Created)
            {
                System.Diagnostics.Debug.Write(resp.Headers.Location + "\n");
                reportLocation = resp.Headers.Location;

                isCreated = true;
            }
        }

        private void worker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            cmdGetReportStatus.Text = "&Check Report Status";
            progressGetReportStatus.Style = ProgressBarStyle.Blocks;
            txtStopTime.Text = DateTime.Now.ToString();
        }

        private void txtPollTime_ModifiedChanged(object sender, EventArgs e)
        {
            
        }

        private void txtPollTime_Validating(object sender, CancelEventArgs e)
        {
            if (Int32.Parse(txtPollTime.Text) < 5)
            {
                MessageBox.Show("Valid range is from 5 to " + Int32.MaxValue, "IssuesReportASM");
                this.Text = "5";
            }
        }
    }
}
