/**
 * This sample program is provided AS IS and may be used, executed, copied and modified without royalty payment by customer (a) for its own instruction and study, (b) in order to develop applications designed to run with an IBM WebSphere product, either for customer's own internal use or for redistribution by customer, as part of such an application, in customer's own products.
 * Products 5724-T52, 5724-T53, 5724-T57, 5724-T58, 5724-V03, 5724-T51, (C) COPYRIGHT International Business Machines Corp., 2012
 * All Rights Reserved * Licensed Materials - Property of IBM
 *
 * EnableTDE.sql
 * Script provided to enable TDE (Transparent Data Encryption) on a SQL 2008 or 2012 database
 */
 
----------------------------------------------------------------------------------------
--------------------------------- ACTION REQUIRED --------------------------------------
-- NOTE:  BEFORE EXECUTING THIS SCRIPT, PROVIDE VALUES IN THE FOLLOWING BLOCK SPECIFIC TO YOUR ORGANIZATION.
--			@MKPassword - The password used to create/access the master key stored in the [master] database
--			@DatabaseName - Update 'Insert Database Name Here' with the name of the database to enable encryption on

-- ACTION REQUIRED: Indicate the Master Key password, EXAMPLE:  DECLARE @MKPassword NVARCHAR(255) = 'MyPassword_123456..'
DECLARE @MKPassword NVARCHAR(255) = 'Insert Master Key Password Here'

-- ACTION REQUIRED: Indicate the database to encrypt, EXAMPLE:  DECLARE @DatabaseName NVARCHAR(255) = 'DATABASENAME'
DECLARE @DatabaseName NVARCHAR(255) = 'Insert Database Name Here'
	
-- Optional: You can indicate a different Backup password used to secure the exported certificate, EXAMPLE:  DECLARE @BackupPassword NVARCHAR(255) = 'MyBackupPassword_123456..'
DECLARE @BackupPassword NVARCHAR(255) = @MKPassword
----------------------------------------------------------------------------------------
---------------------- AT THIS POINT, THE SCRIPT IS READY TO RUN -----------------------
----------------------------------------------------------------------------------------


-- Step 0. Check if this version is SQL SERVER Enterprise Edition
-----------------------------------------------------------------------------------------
-- 1804890536 = Enterprise, 1872460670 = Enterprise Edition: Core-based Licensing, 610778273= Enterprise Evaluation, -2117995310 = Developer
IF (select serverproperty('EditionID')) not in (1804890536, 1872460670, 610778273, -2117995310) BEGIN
	PRINT 'ERROR 0: TDE is only available on SQL Server 2008 Enterprise Edition and higher. ';
	declare @ErrorMessage nvarchar(1000)
	set @ErrorMessage = '         The current edition is: ' + cast((select serverproperty('Edition')) as nvarchar)
	PRINT  @ErrorMessage;
	RETURN
END


DECLARE @sql NVARCHAR(4000)
-- Step 1.  Master Key.  Creates it if it does not exist using specified password above
----------------------------------------------------------------------------------------
BEGIN TRY
--	PRINT 'INFO: Check for master key.  If it does not exist, create one with specified password'
	SET @sql = 'USE master; IF NOT EXISTS(SELECT 1 FROM sys.symmetric_keys WHERE name LIKE ''%MS_DatabaseMasterKey%'') BEGIN CREATE MASTER KEY ENCRYPTION BY PASSWORD = ''' + @MKPassword + ''' END'
	EXEC sp_executesql @sql
END TRY
BEGIN CATCH
     PRINT 'ERROR 1: ' + ERROR_MESSAGE();
     RETURN
END CATCH

-- Step 2.  Opens the Master Key with the specified password
---------------------------------------------------------------------------------------
BEGIN TRY
--	PRINT 'INFO: Open master key with specified password'
	SET @sql = 'USE master; OPEN MASTER KEY DECRYPTION BY PASSWORD = ''' + @MKPassword + ''''
	EXEC sp_executesql @sql
END TRY
BEGIN CATCH
     PRINT 'ERROR 2: ' + ERROR_MESSAGE();
     RETURN
END CATCH

-- Step 3.  Create the "AppScan" certificate using the Master Key and BACK IT UP.
-- These backup files are REQUIRED in order to move the database to another server or restore a backup.
--
-- This step will generate 2 files AppScanEntCert.bak, and AppScanEntCert.pvk.  Both are required.
--
-- By default the files can be found alongside the database .mdf file:
-- (SQL 2012) C:\Program Files\Microsoft SQL Server\MSSQL11.MSSQLSERVER\MSSQL\DATA
-- (SQL 2008) C:\Program Files\Microsoft SQL Server\MSSQL10.MSSQLSERVER\MSSQL\DATA
-- (SQL 2008 R2) C:\Program Files\Microsoft SQL Server\MSSQL10_50.MSSQLSERVER\MSSQL\DATA
---------------------------------------------------------------------------------------
BEGIN TRY
--	PRINT 'INFO: Create and Backup AppScan Enterprise Certificate if it does not exist'
	SET @sql = 'USE master; IF NOT EXISTS (select 1 from sys.certificates  where name = ''APPSCAN_ENT_CERT'') BEGIN CREATE CERTIFICATE APPSCAN_ENT_CERT WITH SUBJECT = ''IBM Security AppScan Enterprise Certificate'';' +
			   'BACKUP CERTIFICATE APPSCAN_ENT_CERT TO FILE = ''AppScanEntCert.bak'' WITH PRIVATE KEY (FILE = ''AppScanEntCert.pvk'', ENCRYPTION BY PASSWORD = ''' + @BackupPassword + ''');  END' 
	EXEC sp_executesql @sql
END TRY
BEGIN CATCH
     PRINT 'ERROR 3: ' + ERROR_MESSAGE();
     RETURN
END CATCH

-- Step 4.  Associate the AppScan Enterprise Certificate with the current database
---------------------------------------------------------------------------------------
BEGIN TRY
	SET @sql = 'USE ['+@DatabaseName+']; '
	SET @sql = @sql + 'if NOT EXISTS (select 1 from sys.dm_database_encryption_keys sysKey	inner join sys.databases sysDB on sysDB.database_id = sysKey.database_id where sysDB.name = db_name()) BEGIN' +
			   ' CREATE DATABASE ENCRYPTION KEY WITH ALGORITHM = AES_256 ENCRYPTION BY SERVER CERTIFICATE APPSCAN_ENT_CERT; END '
	EXEC sp_executesql @sql;
END TRY
BEGIN CATCH
     PRINT 'ERROR 4: ' + ERROR_MESSAGE();
     RETURN
END CATCH

-- Step 5.  Enable encryption on the current database
---------------------------------------------------------------------------------------
BEGIN TRY
	SET @sql = 'USE ['+@DatabaseName+']; '
	SET @sql = @sql + 'IF NOT EXISTS (select 1 from sys.databases where name = ''' + @DatabaseName + ''' and is_encrypted = 1) BEGIN ALTER DATABASE [' + @DatabaseName + '] SET ENCRYPTION ON; END '
	EXEC sp_executesql @sql;
END TRY
BEGIN CATCH
     PRINT 'ERROR 5: ' + ERROR_MESSAGE();
     RETURN
END CATCH

-- Step 6.  Test and display the result.
---------------------------------------------------------------------------------------
BEGIN TRY
	PRINT '---------------- ACTION REQUIRED ----------------------'
	PRINT '    You must backup the 2 files AppScanEntCert.bak, and AppScanEntCert.pvk. By default the files can be found alongside the database .mdf file:'
	PRINT '        (SQL 2012) C:\Program Files\Microsoft SQL Server\MSSQL11.MSSQLSERVER\MSSQL\DATA '
	PRINT '        (SQL 2008) C:\Program Files\Microsoft SQL Server\MSSQL10.MSSQLSERVER\MSSQL\DATA '
	PRINT '        (SQL 2008 R2) C:\Program Files\Microsoft SQL Server\MSSQL10_50.MSSQLSERVER\MSSQL\DATA '
	PRINT '-------------------------------------------------------'
	PRINT '----------------------- INFO --------------------------'

	-- if db is encrypted	
	SET @sql = 'IF (select encryption_state from sys.dm_database_encryption_keys where DB_NAME(database_id) = ''' + @DatabaseName + ''') = 3 begin'
	SET @sql = @sql + ' PRINT '' The Database ' + @DatabaseName + ' is encrypted. ''  end else '
	-- if encryption is in progress	
	SET @sql = @sql + 'IF (select encryption_state from sys.dm_database_encryption_keys where DB_NAME(database_id) = ''' + @DatabaseName + ''') = 2 begin'
	SET @sql = @sql + ' PRINT '' The encryption of the Database ' + @DatabaseName + ' is in progress. '' '
	-- the percentage of the progress
	SET @sql = @sql + ' declare @percentage nvarchar(100) '
	SET @sql = @sql + ' select @percentage = cast(percent_complete as nvarchar) from sys.dm_database_encryption_keys where DB_NAME(database_id) = ''' + @DatabaseName + ''''
	SET @sql = @sql + ' PRINT '' It is currently '' + @percentage + '' percent complete.'''
	SET @sql = @sql + ' PRINT '' You can run this script again to get an up-to-date percentage. '''
	-- the db is not encrypted
	SET @sql = @sql + ' end else begin '
	SET @sql = @sql + ' PRINT '' Error: The Database ' + @DatabaseName + ' is not encrypted. ''  end'
	
	EXEC sp_executesql @sql;
	
END TRY
BEGIN CATCH
     PRINT 'ERROR 6: ' + ERROR_MESSAGE();
     RETURN
END CATCH
