﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.IO;
using System.Net;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net.Http;
using System.Text.RegularExpressions;

namespace ASE_XML_IssuesReport
{
    public partial class IssuesReport : Form
    {
        ASEHelper ase = null;
        bool LoggedIn = false;
        const int MaxResponseLength = 5000000;
        public IssuesReport()
        {
            InitializeComponent();
        }

        private async Task<bool> Login() {
            HttpResponseMessage resp = null;

            if (ase==null)
                ase = new ASEHelper();

            try
            {
                if (!LoggedIn)
                {
                    UriHostNameType uriType = ase.CheckBaseUrlHost(txtASEBaseURL.Text);
                    if(uriType==UriHostNameType.Dns)
                    {
                        try
                        {
                            Dns.GetHostEntry(new Uri(txtASEBaseURL.Text).Host);
                        } catch (Exception dnsEx) 
                        {
                            txtReport.AppendText("Unable to resolve host " + new Uri(txtASEBaseURL.Text).Host + Environment.NewLine);
                            throw dnsEx;
                        }

                    }
                    txtReport.AppendText("BaseURL = "+uriType.ToString()+ Environment.NewLine);

                    txtReport.AppendText(Environment.NewLine+"- LOGIN ----------" + Environment.NewLine);
                    txtReport.AppendText("Logging into "+txtASEBaseURL.Text+" as "+txtUserName.Text+Environment.NewLine);
                    txtReport.AppendText("----------" + Environment.NewLine);


                    ase.TrustAllCerts(chkTrustCerts.Checked);
                    
                    resp = await ase.Login(txtASEBaseURL.Text, txtUserName.Text, txtPassword.Text);
                    if (resp != null)
                    {
                        lblLoginStatus.Text = resp.StatusCode.ToString();
                        if (resp.StatusCode == System.Net.HttpStatusCode.OK)
                        {
                            LoggedIn = true;
                            txtReport.AppendText(resp.Content.ReadAsStringAsync().Result + Environment.NewLine);
                            txtReport.AppendText("----------" + Environment.NewLine);

                        }
                        else if (resp.StatusCode == System.Net.HttpStatusCode.NotFound)
                        {
                            LoggedIn = false;
                            txtReport.AppendText("BASE URL NOT FOUND!" + Environment.NewLine);
                            txtReport.AppendText("----------" + Environment.NewLine);
                            
                            ase = null;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += txtASEBaseURL.Text + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (ex.InnerException != null)
                {
                    exceptionMessage += ex.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += ex.Message + Environment.NewLine;
                    exceptionMessage += ex.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;


                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);

                ase = null;
                LoggedIn = false;
                return false;
            }
            return true;
        }
        private async Task<bool> Logout()
        {
            HttpResponseMessage resp = null;

            try
            {
                if (LoggedIn)
                {
                    txtReport.AppendText(Environment.NewLine + "- LOGOFF ----------" + Environment.NewLine);
                    txtReport.AppendText("Logging out of " + txtASEBaseURL.Text + " as " + txtUserName.Text + Environment.NewLine);
                    txtReport.AppendText("----------" + Environment.NewLine);
                    resp = await ase.Logout();
                    lblLoginStatus.Text = resp.StatusCode.ToString();
                    if (resp.StatusCode == System.Net.HttpStatusCode.OK)
                    {
                        LoggedIn = false;
                    }
                }
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.Write(ex.Message + ex.StackTrace);
                LoggedIn = false;
                return false;
            }
            return true;
        }

        private long WriteToFile(String filename,Stream stream)
        {
            long fsSize;

            FileStream fs = new FileStream(filename, FileMode.Create);

            stream.CopyTo(fs);
            fsSize = fs.Length;

            fs.Close();

            return fsSize;
        }

        private async void btnLogin_Click(object sender, EventArgs e)
        {
            if(!LoggedIn)
            {
                await Login();
            }
        }

        private async void btnReportGet_Click(object sender, EventArgs e)
        {
            HttpResponseMessage resp;

            if (!LoggedIn && chkAutoLogin.Checked==true)
            {
                await Login();
            }
            if (LoggedIn)
            {
                txtReport.AppendText("- GET REPORT ----------" + Environment.NewLine);
                txtReport.AppendText("Generating GET report for " + txtReportNum.Text + Environment.NewLine);
                txtReport.AppendText("----------" + Environment.NewLine);

                resp = await ase.GetReport(Int32.Parse(txtReportNum.Text));
                while (resp.StatusCode == System.Net.HttpStatusCode.Created) // 201 received
                {
                    Regex re = new Regex("<continue.*href=\".*/tasks/([0-9]*)\"", RegexOptions.Multiline);
                    Match m = re.Match(resp.Content.ReadAsStringAsync().Result);
                    if (m.Success)
                    {
                        System.Windows.Forms.MessageBox.Show(m.Groups[1].Value);
                        int taskNum = Int32.Parse(m.Groups[1].Value);
                        txtReport.AppendText("Continue request recieved; continuing task " + taskNum.ToString() + Environment.NewLine);
                        resp = await ase.ContinueTask(taskNum);
                    }
                }

                if (resp.Content.Headers.ContentLength < MaxResponseLength)
                {
                    txtReport.AppendText(resp.Content.ReadAsStringAsync().Result);
                }
                else
                {
                    txtReport.AppendText("Response is " + resp.Content.Headers.ContentLength + " in size and is too large to display" + Environment.NewLine);
                }
                if (chkSaveToFile.Checked == true)
                {
                    long fsSize = 0;
                    fsSize = WriteToFile(txtFileName.Text, resp.Content.ReadAsStreamAsync().Result);
                    if (fsSize > 0 && resp.Content.Headers.ContentLength >= MaxResponseLength)
                    {
                        txtReport.AppendText("Wrote " + fsSize.ToString() + " bytes to " + txtFileName.Text);
                    }
                }
                await Logout();
                // clear ase client object for memory reasons
                ase = null;
                LoggedIn = false;
                lblLoginStatus.Text = "Not Logged In";
            }
        }

        private async void btnReportPost_Click(object sender, EventArgs e)
        {
            HttpResponseMessage resp;

            if (!LoggedIn && chkAutoLogin.Checked == true)
            {
                await Login();
            }
            if (LoggedIn)
            {
                txtReport.AppendText("- POST REPORT ----------" + Environment.NewLine);
                txtReport.AppendText("Generating POST report for " + txtReportNum.Text + Environment.NewLine);
                txtReport.AppendText("Filter: " + txtFilterString.Text + Environment.NewLine);
                txtReport.AppendText("----------" + Environment.NewLine);
                try
                {
                    resp = await ase.PostReport(Int32.Parse(txtReportNum.Text), txtFilterString.Text);
                    while (resp.StatusCode == System.Net.HttpStatusCode.Created) // 201 received
                    {
                        Regex re = new Regex("<continue.*href=\".*/tasks/([0-9]*)\"", RegexOptions.Multiline);
                        Match m = re.Match(resp.Content.ReadAsStringAsync().Result);
                        if (m.Success)
                        {
                            System.Windows.Forms.MessageBox.Show(m.Groups[1].Value);
                            int taskNum = Int32.Parse(m.Groups[1].Value);
                            txtReport.AppendText("Continue request recieved; continuing task " + taskNum.ToString() + Environment.NewLine);
                            resp = await ase.ContinueTask(taskNum);
                        }
                    }


                    if (resp.Content.Headers.ContentLength < MaxResponseLength)
                    {
                        txtReport.AppendText(resp.Content.ReadAsStringAsync().Result);
                    }
                    else
                    {
                        txtReport.AppendText("Response is " + resp.Content.Headers.ContentLength + " in size and is too large to display" + Environment.NewLine);
                    }
                    if (chkSaveToFile.Checked == true)
                    {
                        long fsSize = 0;
                        fsSize = WriteToFile(txtFileName.Text, resp.Content.ReadAsStreamAsync().Result);
                        if (fsSize > 0 && resp.Content.Headers.ContentLength >= MaxResponseLength)
                        {
                            txtReport.AppendText("Wrote " + fsSize.ToString() + " bytes to " + txtFileName.Text);
                        }
                    }
                }
                catch (Exception exp)
                {
                    System.Windows.Forms.MessageBox.Show(exp.Message + exp.StackTrace);
                }
                await Logout();

                // clear ase client object for memory reasons
                ase = null;
                LoggedIn = false;
                lblLoginStatus.Text = "Not Logged In";
            }
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            txtReport.Clear();
        }

    }
}
