﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net.Http;
using Newtonsoft.Json;

namespace ASE_XML_IssuesReport
{
    public partial class ASMTest : Form
    {
        ASMHelper asm = new ASE_XML_IssuesReport.ASMHelper();
        public ASMTest()
        {
            InitializeComponent();
        }

        private void ASMTest_Load(object sender, EventArgs e)
        {

        }

        private async void button1_Click(object sender, EventArgs e)
        {
            
            HttpResponseMessage resp;
            resp = await asm.Login("https://hostname:9443/ase", "username", "password");

        }

        private async void button2_Click(object sender, EventArgs e)
        {
            await asm.Logout();
        }

        Uri reportLocation;
        Uri reportStatusLocation;
        private async void button3_Click(object sender, EventArgs e)
        {
            HttpResponseMessage resp;

            resp = await asm.GetSecurityDetailsReport(5);
            
            if(resp.StatusCode == System.Net.HttpStatusCode.Accepted)
            {
                System.Diagnostics.Debug.Write(resp.Headers.Location + "\n");
                reportStatusLocation = resp.Headers.Location;
            }
            
        }

        private async void button4_Click(object sender, EventArgs e)
        {
            HttpResponseMessage resp;

            if (reportStatusLocation == null) {
                System.Diagnostics.Debug.Write("No Report Status Location" + "\n");
                return;
            }

            resp = await asm.GetReportStatus(reportStatusLocation);
            if(resp.StatusCode == System.Net.HttpStatusCode.Created)
            {
                System.Diagnostics.Debug.Write(resp.Headers.Location + "\n");
                reportLocation = resp.Headers.Location;
            }
        }

        private async void button5_Click(object sender, EventArgs e)
        {
            HttpResponseMessage resp;
            if (reportLocation == null)
            {
                System.Diagnostics.Debug.Write("No Report Location" + "\n");
                return;
            }
            resp = await asm.GetReport(reportLocation);
            if (resp.StatusCode == System.Net.HttpStatusCode.OK)
            {
                System.IO.FileStream fs = new System.IO.FileStream("Report.zip", System.IO.FileMode.Create);

                await resp.Content.ReadAsStreamAsync().Result.CopyToAsync(fs);
                fs.Close();
            }
        }
    }
}
