/**
 * This sample program is provided AS IS and may be used, executed, copied and modified without royalty payment by customer (a) for its own
 * instruction and study, (b) in order to develop applications designed to run with an IBM WebSphere product, either for customer's own internal use
 * or for redistribution by customer, as part of such an application, in customer's own products.
 * 
 * Products 5724-T52, 5724-T53, 5724-T57, 5724-T58, 5724-V03, 5724-T51, (C) COPYRIGHT International Business Machines Corp., 2010-2015
 * All Rights Reserved * Licensed Materials - Property of IBM
 */
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Sample which illustrates a basic automation workflow in AppScan Enterprise:
 * Login
 * Choose a scan template
 * Create a scan
 * Set some configuration options
 * Run the scan
 * Run the reports
 * Select some report data
 * 
 * Last Updated: Jan 16, 2015
 *
 */
public class Sample {

	// AppScan Enterprise Configuration

	/**
	 * AppScan Enterprise Control Center Services URL
	 */
	private static String BASE_URL = "https://localhost/ase/services/";

	/**
	 * User to log into ASE
	 */
	private static String ASE_USER = "admin";

	/**
	 * Password to log into ASE
	 */
	private static String ASE_PASS = "password";

	// Test data

	/**
	 * Template to use when creating a new scan
	 */
	private static String SCAN_TEMPLATE_NAME = "Altoro Mutual";

	/**
	 * URL of site to scan
	 */
	private static String START_URL = "http://www.altoromutual.com/";

	/**
	 * User to log into the site as
	 */
	private static String SCAN_USERNAME = "jsmith";

	/**
	 * Password to use when logging into the site
	 */
	private static String SCAN_PASSWORD = "Demo1234";

	/**
	 * Persist cookies across requests
	 */
	private static String cookieContainer = "";

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		// Server needs TLSv1 or higher
		System.setProperty("https.protocols", "TLSv1");
		
		
		// FOR TESTING PURPOSE ONLY - You can disable certificate validation
		// disableCertificateValidation();

	    
	    
		try {
	
			// Initialization of XPath utilities
			XPathFactory factory = XPathFactory.newInstance();
			XPath xpath = factory.newXPath();
			xpath.setNamespaceContext(_nsContext);

			String loginPostData = "";

			// Authenticate
			loginPostData = "userid=" + ASE_USER + "&password=" + ASE_PASS;
			print("Login");

			// Log in
			Document response = sendRESTRequest("login", loginPostData);
			checkForError(response, null);

			// Write out the logged in user
			print((String) xpath.evaluate("//ase:version/ase:user-name/text()", response));
			// Write out the Server version
			print((String) xpath.evaluate("//ase:version/ase:build/text()", response));

			// Get Scan Template ID
			print("Retrieving the identifier of the " + SCAN_TEMPLATE_NAME + " template...");
			response = sendRESTRequest("templates", "");

			checkForError(response, null);

			// Search for desired template in the list of returned templates
			String templateId = (String) xpath.evaluate("//ase:content-scan-job[ase:name='" + SCAN_TEMPLATE_NAME + "']/ase:id/text()", response, XPathConstants.STRING);

			// Create a new Scan based on the template
			print("Creating a scan based on the " + SCAN_TEMPLATE_NAME + " template...");
			response = sendRESTRequest("folderitems?templateId=" + templateId, "name=" + URLEncoder.encode("Sample Scan " + new Date().toString(), "UTF-8") + "&description=" + URLEncoder.encode("A scan created via REST services", "UTF-8"));
			checkForError(response, null);

			// Pick out created scan & report URL for use later
			String scanURL = (String) xpath.evaluate("//ase:content-scan-job/@href", response, XPathConstants.STRING);
			String optionsURL = (String) xpath.evaluate("//ase:content-scan-job/ase:options/@href", response, XPathConstants.STRING);
			String reportPackURL = (String) xpath.evaluate("//ase:report-pack/@href", response, XPathConstants.STRING);
			String reportsURL = (String) xpath.evaluate("//ase:report-pack/ase:reports/@href", response, XPathConstants.STRING);

			// Pull out some information about the scan and report pack
			String scanLastRunDateTime = (String) xpath.evaluate("//ase:content-scan-job/ase:last-run/text()", response, XPathConstants.STRING);
			print(scanLastRunDateTime);

			String reportPackLastRunDateTime = (String) xpath.evaluate("//ase:report-pack/ase:last-run/text()", response, XPathConstants.STRING);
			print(reportPackLastRunDateTime);

			// Set the starting URL
			print("Updating the starting URL of the newly created scan.");
			response = sendRESTRequest(optionsURL + "/" + OptionType.STARTING_URLS, "value=" + URLEncoder.encode(START_URL, "UTF-8"));

			// The template we use already has the starting url set, but we want to show how to do this in the sample
			// So we will expect a particular error in this case (starting url already exists)
			List<String> expectedCodes = new ArrayList<String>();
			expectedCodes.add("CRWAE0014E");
			checkForError(response, expectedCodes);

			// Set the username
			print("Updating the username");
			response = sendRESTRequest(optionsURL + "/" + OptionType.AUTOMATIC_LOGIN_USERNAME, "value=" + URLEncoder.encode(SCAN_USERNAME, "UTF-8"));
			checkForError(response, null);

			// Set the password
			print("Updating the password");
			response = sendRESTRequest(optionsURL + "/" + OptionType.AUTOMATIC_LOGIN_PASSWORD, "value=" + URLEncoder.encode(SCAN_PASSWORD, "UTF-8"));
			checkForError(response, null);

			// Run the scan (by setting the action), report pack will run after
			// scan is complete
			print("Running the scan.");
			response = sendRESTRequest(scanURL, "action=" + ScanAction.RUN);
			checkForError(response, null);

			// Wait for scan completion
			waitForCompletion(scanURL, scanLastRunDateTime);
			// Wait for report pack completion
			waitForCompletion(reportPackURL, reportPackLastRunDateTime);

			// Get results of scan
			print("Retrieving report summary information...");
			response = sendRESTRequest(reportsURL, "");
			checkForError(response, null);

			String secIssuesCount = (String) xpath.evaluate("//ase:report[ase:name='Security Issues']/ase:summary/ase:sentence/text()", response, XPathConstants.STRING);
			print("Security Issues:" + secIssuesCount);

			String secIssuesDataURL = (String) xpath.evaluate("//ase:report[ase:name='Security Issues']/ase:data/@href", response, XPathConstants.STRING);
			print(secIssuesDataURL);

			// Ask for all the data (don't worry about paging through data in a
			// sample)
			String secIssuesAllDataURL = secIssuesDataURL + "?mode=all";

			// Also get the schema for this report
			String secIssuesSchemaURL = secIssuesDataURL + "?metadata=schema";

			print("Retrieving report schema information...");
			response = sendRESTRequest(secIssuesSchemaURL, "");
			checkForError(response, null);
			printOuterXml(response);

			print("Retrieving report detail information...");
			response = sendRESTRequest(secIssuesAllDataURL, "");
			checkForError(response, null);
			printOuterXml(response);

		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	private static void disableCertificateValidation(){
		TrustManager[] trustAllCerts = new TrustManager[] {
	       new X509TrustManager() {
	          public java.security.cert.X509Certificate[] getAcceptedIssuers() {
	            return null;
	          }

	          public void checkClientTrusted(X509Certificate[] certs, String authType) {  }

	          public void checkServerTrusted(X509Certificate[] certs, String authType) {  }

	       }
	    };

	    SSLContext sc = null;
		try {
			sc = SSLContext.getInstance("SSL");
		} catch (NoSuchAlgorithmException e1) {
		}
		
	    try {
			sc.init(null, trustAllCerts, new java.security.SecureRandom());
		} catch (KeyManagementException e1) {
		}
	    
	    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());

	    // Create all-trusting host name verifier
	    HostnameVerifier allHostsValid = new HostnameVerifier() {
	        public boolean verify(String hostname, SSLSession session) {
	          return true;
	        }
	    };
	    // Install the all-trusting host verifier
	    HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
	}

	/**
	 * Prints the OuterXml of a document
	 * 
	 * @param response
	 */
	private static void printOuterXml(Document response) throws Exception {
		Transformer transformer = TransformerFactory.newInstance().newTransformer();
		transformer.setOutputProperty("omit-xml-declaration", "yes");

		StringWriter writer = new StringWriter();
		transformer.transform(new DOMSource(response.getDocumentElement()), new StreamResult(writer));
		print(writer.toString());
	}

	/**
	 * waits for an item to complete
	 * 
	 * @param url
	 *            - object URL
	 * @param lastRunDate
	 *            - last time this was run. We wait until the timestamp is updated to declare the item done
	 */
	private static void waitForCompletion(String url, String lastRunDate) throws Exception {

		XPathFactory factory = XPathFactory.newInstance();
		XPath xpath = factory.newXPath();
		xpath.setNamespaceContext(_nsContext);

		int retries = 0;
		int maxRetries = 120; // 10 mins. This should be adjusted to a more
		// realistic number for long scans
		while (retries < maxRetries) {
			Document response = sendRESTRequest(url, "");
			checkForError(response, null);

			// Get the status and print it
			String status = (String) xpath.evaluate("//ase:state/ase:name/text()", response, XPathConstants.STRING);
			print(status);

			Double scanState = (Double) xpath.evaluate("//ase:state/ase:id/text()", response, XPathConstants.NUMBER);
			if (scanState.intValue() == ScanState.READY) {
				// If scan marked ready, check last run time to verify
				// completion
				String lastRunDateTime = (String) xpath.evaluate("//ase:last-run/text()", response, XPathConstants.STRING);
				if (lastRunDateTime.compareTo(lastRunDate) != 0)
					return;

			} else if (scanState.intValue() == ScanState.SUSPENDED) {
				// An error has occurred
				throw new Exception("Object has suspended.");
			}

			print("Continue to wait for completion...");
			retries++;
			Thread.sleep(5000);
		}

		// Exceeded wait threshold
		throw new Exception("Wait threshold exceeded.");
	}

	/**
	 * Prints to the console
	 * 
	 * @param message
	 */
	private static void print(String message) {
		System.out.println(message);
	}

	/**
	 * 
	 * @param service
	 *            - URL of the REST service call
	 * @param data
	 *            - (optional) Content of the POST data (XML). When empty, using GET.
	 * @return Response (XML)
	 * @throws Exception
	 */
	private static Document sendRESTRequest(String service, String data) throws Exception {
		DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
		domFactory.setNamespaceAware(true); // never forget this!

		DocumentBuilder builder = domFactory.newDocumentBuilder();

		URL url = null;

		if (!service.startsWith("http"))
			url = new URL(BASE_URL + service);
		else
			url = new URL(service);

		HttpURLConnection conn = (HttpURLConnection) url.openConnection();
		conn.setDoInput(true);
		conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");

		if (cookieContainer.length() > 0) {
			conn.setRequestProperty("Cookie", cookieContainer);
		}

		print(url.toString());

		if (data.length() > 0) {
			print(data);
			conn.setRequestMethod("POST");
			conn.setDoOutput(true);
			OutputStreamWriter wr = null;
			try {
				wr = new OutputStreamWriter(conn.getOutputStream());
				wr.write(data);
				wr.flush();
			} finally {
				if (wr != null) {
					wr.close();
				}
			}
		}
		try {
			return builder.parse(new InputSource(conn.getInputStream()));
		} catch (SAXException e) {
			print(e.toString());
			return builder.parse(new InputSource(conn.getErrorStream()));
		} catch (IOException e) {
			print(e.toString());
			return builder.parse(new InputSource(conn.getErrorStream()));
		} finally {
			// Update cookies
			Map<String, List<String>> responseHeaders = conn.getHeaderFields();
			List<String> cookies = responseHeaders.get("Set-Cookie");
			if (cookies != null && cookies.size() > 0) {
				for (String cookie : cookies) {
					if (cookieContainer.length() > 0)
						cookieContainer += ", ";

					cookieContainer += cookie;
				}
			}
			conn.disconnect();
		}
	}

	/**
	 * Checks for an error in the response
	 * 
	 * @param doc
	 * @param expectedCodes
	 *            a list of CRW** codes that are accepted
	 * @throws Exception
	 */
	private static void checkForError(Document doc, List<String> expectedCodes) throws Exception {
		Element rootElement = doc.getDocumentElement();
		if ("error".equalsIgnoreCase(rootElement.getTagName())) {
			print("*** Error Occurred ***");
			NodeList nodes = rootElement.getChildNodes();
			for (int i = 0; i < nodes.getLength(); i++) {
				Node node = nodes.item(i);
				String nodeName = node.getLocalName();

				if ("code".equalsIgnoreCase(nodeName)) {
					String code = node.getChildNodes().item(0).getNodeValue();
					print(code);
					if (expectedCodes != null && expectedCodes.contains(code)) {
						return;
					}
				} else if ("message".equalsIgnoreCase(nodeName)) {
					print(node.getChildNodes().item(0).getNodeValue());
				} else if ("help".equalsIgnoreCase(nodeName)) {
					print(node.getAttributes().item(0).getNodeValue());
				}
			}
			throw new Exception("Unexpected error.");
		}
	}

	/**
	 * Setup namespace context to be used by XPath expressions
	 * 
	 */
	private static NamespaceContext _nsContext;
	static {
		_nsContext = new NamespaceContext() {
			public String getNamespaceURI(String prefix) {
				if (prefix.equalsIgnoreCase("ase"))
					return "http://www.ibm.com/Rational/AppScanEnterprise";
				return XMLConstants.NULL_NS_URI;
			}

			public String getPrefix(String arg0) {
				return null;
			}

			public Iterator<?> getPrefixes(String arg0) {
				return null;
			}
		};
	}

}
