﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Threading.Tasks;

namespace ASE_XML_IssuesReport
{
    class ASEHelper
    {
        HttpClient client = null;

        String baseUrl;
        
        public ASEHelper()
        {
            client = new HttpClient();
        }

        public UriHostNameType CheckBaseUrlHost(String baseUrlStr)
        {
            return Uri.CheckHostName(new Uri(baseUrlStr).Host);
        }

        public void TrustAllCerts(Boolean state)
        {
            if (state)
            {
                if (ServicePointManager.ServerCertificateValidationCallback == null)
                    ServicePointManager.ServerCertificateValidationCallback +=
                    (sender, cert, chain, sslPolicyErrors) => true;
            }
            else
            {
                ServicePointManager.ServerCertificateValidationCallback = null;
            }
        }
        public async Task<HttpResponseMessage> Login(String baseUrlStr, String username, String password)
        {
            StringContent content;
            HttpResponseMessage resp=null;
            Uri uri;

            this.baseUrl = VirtualPathUtility.AppendTrailingSlash(baseUrlStr);
            uri = new Uri(baseUrl + "services/login");

            try
            {
                client.Timeout = new TimeSpan(0, 12, 0);

                content = new StringContent("userid=" + username + "&password=" + password);
                content.Headers.ContentType = new System.Net.Http.Headers.MediaTypeHeaderValue("application/x-www-form-urlencoded");


                System.Diagnostics.Debug.Write("Making login request to " + uri + "\n");

                resp = await client.PostAsync(uri, content);
                System.Diagnostics.Debug.Write("Response code: " + resp.StatusCode + "\n");
                System.Diagnostics.Debug.Write("Response: " + resp.Content.ReadAsStringAsync().Result + "\n");

            }
            catch (Exception e)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += uri.ToString() + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (e.InnerException != null)
                {
                    exceptionMessage += e.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += e.Message + Environment.NewLine;
                    exceptionMessage += e.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;

                
                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);
            }

            return resp;

        }

        public async Task<HttpResponseMessage> Logout()
        {
            HttpResponseMessage resp = null;

            Uri uri = new Uri(baseUrl + "services/logout");

            try
            {
                System.Diagnostics.Debug.Write("Making logoff request to " + uri + "\n");
                resp = await client.GetAsync(uri);
                System.Diagnostics.Debug.Write("Response code: " + resp.StatusCode + "\n");
                System.Diagnostics.Debug.Write("Response: " + resp.Content.ReadAsStringAsync().Result + "\n");
            }
            catch (Exception e)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += uri.ToString() + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (e.InnerException != null)
                {
                    exceptionMessage += e.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += e.Message + Environment.NewLine;
                    exceptionMessage += e.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;


                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);
            }

            return resp;

        }

        public async Task<HttpResponseMessage> ContinueTask(int tasknum)
        {
            Uri uri = new Uri(baseUrl + "/services/tasks/" + tasknum);
            HttpResponseMessage resp = null;

            try
            {
                System.Diagnostics.Debug.Write("Making Task continue call for Task " + tasknum + "\n");
                resp = await client.GetAsync(uri);
                System.Diagnostics.Debug.Write("Response code: " + resp.StatusCode + "\n");
                System.Diagnostics.Debug.Write("Response size: " + resp.Content.ReadAsStringAsync().Result.Length + "\n");
            }
            catch (Exception e)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += uri.ToString() + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (e.InnerException != null)
                {
                    exceptionMessage += e.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += e.Message + Environment.NewLine;
                    exceptionMessage += e.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;


                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);
            }
            return resp;
        }

        public async Task<HttpResponseMessage> GetReport(int reportnum)
        {
            Uri uri = new Uri(baseUrl + "/services/reports/" + reportnum.ToString() + "/issues");
            HttpResponseMessage resp = null;

            try
            {
                System.Diagnostics.Debug.Write("Making Report call for " + reportnum.ToString() + "\n");
                resp = await client.GetAsync(uri);
                System.Diagnostics.Debug.Write("Response code: " + resp.StatusCode + "\n");
                System.Diagnostics.Debug.Write("Response size: " + resp.Content.ReadAsStringAsync().Result.Length + "\n");
            }
            catch (Exception e)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += uri.ToString() + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (e.InnerException != null)
                {
                    exceptionMessage += e.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += e.Message + Environment.NewLine;
                    exceptionMessage += e.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;


                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);
            }
            return resp;
        }

        public async Task<HttpResponseMessage> PostReport(int reportnum)
        {
            return await PostReport(reportnum, "<report-view><filters><filter field =\"issue - severity\" value=\"300|400\" in=\"true\" /><filter field=\"issue-status\" value=\"1|3|7\" in=\"true\"/></filters></report-view>");
        }

        public async Task<HttpResponseMessage> PostReport(int reportnum,string filter)

        {
            HttpContent content;
            HttpResponseMessage resp = null;

            Uri uri = new Uri(baseUrl + "/services/reports/" + reportnum.ToString() + "/issues");
            
            content = new StringContent(filter);

            try
            {
                System.Diagnostics.Debug.Write("Making Report call for " + reportnum.ToString() + "\n");

                resp = await client.PostAsync(uri, content);

                System.Diagnostics.Debug.Write("Response code: " + resp.StatusCode + "\n");
                System.Diagnostics.Debug.Write("Content-length: " + resp.Content.Headers.ContentLength + "\n");

            }
            catch (Exception e)
            {
                String exceptionMessage;


                exceptionMessage = "-------" + Environment.NewLine;
                exceptionMessage += uri.ToString() + Environment.NewLine;
                exceptionMessage += "-------" + Environment.NewLine;
                if (e.InnerException != null)
                {
                    exceptionMessage += e.InnerException + Environment.NewLine;
                }
                else
                {
                    exceptionMessage += e.Message + Environment.NewLine;
                    exceptionMessage += e.StackTrace + Environment.NewLine;
                }
                exceptionMessage += "-------" + Environment.NewLine;


                MessageBox.Show(exceptionMessage);
                System.Diagnostics.Debug.Write(exceptionMessage);
            }

            return resp;
        }
    }
}
