// ====================================================
//
// Application Security Management REST API sample
// Last revision: 06/19/2015  (developed using AppScan Enteprise 9.0.2.1)
//
// This example demonstrate a way to get the average number of issues found per application by month
//
// Usage: from the command line 
//    C:\> cscript <current_filename>.js
// 
// ====================================================

// Include dependencies
eval(Include(".\\common_functions.js"));  // Common functions used by different samples
eval(Include(".\\_your_connection_info.js"));  // Your server connection information


if (REST_Login(yourServerName, yourServerPort, yourServerInstance, yourUserName, yourUserPassword))
{
	var activequery = ",status=fixed,status=new,status=open,status=reopened,status=inprogress,classification=definitive,classification=suspect";

	var currentMonth = new Date();
	currentMonth.setDate(1);
	var nextMonth = getNextMonth();
	
	WScript.echo("Avg count of issues per app by month discovered");
	
	for(var monthBack = 0; monthBack < 12; monthBack++) {

		query = "DateCreated=" + getISODate(currentMonth) + "\\," + getISODate(nextMonth);
		group = "Application Name";
		appquery = "";
		var response = REST_GET("summaries/issues_v2", "query=" + encodeURIComponent(query + activequery) + "&group=" + encodeURIComponent(group) + "&appquery="+ encodeURIComponent(appquery));
		printAvgIssueSummaries(response, getISODate(currentMonth));
		
		nextMonth = new Date(currentMonth);
		currentMonth = getPreviousMonth(currentMonth);
	}

	REST_Logout();
}

function getNextMonth() {
	var d = new Date();
	d.setDate(1);
	var month = d.getMonth();
	if(month == 11) {
		d.setMonth(0);
		d.setFullYear(d.getFullYear()+1);
	}
	else {
		d.setMonth(month+1);
	}
	return d;
}

function getPreviousMonth(date) {
	var d = new Date(date);
	d.setDate(1);
	var month = d.getMonth();
	if(month == 0) {
		d.setMonth(11);
		d.setFullYear(d.getFullYear()-1);
	}
	else {
		d.setMonth(month-1);
	}
	return d;
}

function getISODate(date) {
	return date.getFullYear() + "-" + (date.getMonth()+1) + "-" + date.getDate();
}


//=========================================================================
// [Name] : printIssueSummaries
// [Purpose] : Print out the response from issue summaries
//=========================================================================
function printAvgIssueSummaries(response, date) {
	//
	// Process json response which looks like this...
	//
	//	[
	//		{
    //			"id": 29,
    //			"tagGroupId": 13,
    //			"tagId": 1041,
    //			"tagName": "Info",	<-- Use this
    //			"chartColor": "",
    //			"numMatch": 679		<-- And this
	//		},
	//		...
	//
	
    if(response != null) {
    	var aReturnedCounts = getJSONArray(response);

		
		var numTotalApps = aReturnedCounts.length;
		var numTotalIssues = 0;
        for (var index = 0; index < aReturnedCounts.length; index++) {
            var oCount = JSON.parse(aReturnedCounts[index]);
			numTotalIssues += parseInt(oCount.numMatch);
		}
		if(numTotalApps != 0) {
			WScript.echo(date +": "+ (numTotalIssues / numTotalApps));
		}
		else {
			WScript.echo(date + ": n/a");
		}

    }
}






/***********************************************************************************************************/
/***********************************************************************************************************/
//
//        Helper functions
//
/***********************************************************************************************************/
/***********************************************************************************************************/

//=========================================================================
// [Name] : <include()>
// [Purpose] : <Read a script file>
// [Out] :	<file content>
//=========================================================================
function Include(strFname) {
    var objFSO = new ActiveXObject("Scripting.FileSystemObject");
    var objTextFile = objFSO.OpenTextFile(strFname, 1);
    var sReadAll = objTextFile.ReadAll();
    objTextFile.Close();
    return sReadAll;
}
