/**
 * This sample program is provided AS IS and may be used, executed, copied and modified without royalty payment by customer (a) for its own instruction and study, (b) in order to develop applications designed to run with an IBM WebSphere product, either for customer's own internal use or for redistribution by customer, as part of such an application, in customer's own products.
 * Products 5724-T52, 5724-T53, 5724-T57, 5724-T58, 5724-V03, 5724-T51, (C) COPYRIGHT International Business Machines Corp., 2012
 * All Rights Reserved * Licensed Materials - Property of IBM
 *
 * RestoreDBCertificate.sql
 * Script provided to enable TDE (Transparent Data Encryption) on a SQL 2008 or 2012 database
 */
 
----------------------------------------------------------------------------------------
--------------------------------- ACTION REQUIRED --------------------------------------
-- NOTE:  BEFORE EXECUTING THIS SCRIPT, PROVIDE VALUES IN THE FOLLOWING BLOCK SPECIFIC TO YOUR ORGANIZATION.
--			@MKPassword - The password that was used to create the Master key in the EnableTDE.sql script
--          @BackupPassword - The password that ws used to backup the certificate in the EnableTDE.sql script 
--			@Path - The path of the files on this machine: AppScanEntCert.bak and AppScanEntCert.pvk

-- ACTION REQUIRED: Indicate the Master Key password that was used to create the Master key in the EnableTDE.sql script
DECLARE @MKPassword NVARCHAR(255) = 'Insert Master Key Password Here'

-- ACTION REQUIRED: Indicate the password that was used to backup the certificate in the EnableTDE.sql script 
DECLARE @BackupPassword NVARCHAR(255) = @MKPassword

-- ACTION REQUIRED: Indicate the path of the AppScanEntCert.bak and AppScanEntCert.pvk files on this machine, EXAMPLE: 'C:\Certificate\'
DECLARE @Path NVARCHAR(4000) = 'Insert the path here'

----------------------------------------------------------------------------------------
---------------------- AT THIS POINT, THE SCRIPT IS READY TO RUN -----------------------
----------------------------------------------------------------------------------------

DECLARE @sql NVARCHAR(4000)
-- Step 1.  Master Key.  Creates it if it does not exist using specified password above.
----------------------------------------------------------------------------------------
BEGIN TRY
--	PRINT 'INFO: Check for master key.  If it does not exist, create one with specified password'
	SET @sql = 'USE master; IF NOT EXISTS(SELECT 1 FROM sys.symmetric_keys WHERE name LIKE ''%MS_DatabaseMasterKey%'') BEGIN CREATE MASTER KEY ENCRYPTION BY PASSWORD = ''' + @MKPassword + ''' END'
	EXEC sp_executesql @sql
END TRY
BEGIN CATCH
     PRINT 'ERROR 1: ' + ERROR_MESSAGE();
     RETURN
END CATCH

-- Step 2.  Opens the Master Key with the specified password.
---------------------------------------------------------------------------------------
BEGIN TRY
--	PRINT 'INFO: Open master key with specified password'
	SET @sql = 'USE master; OPEN MASTER KEY DECRYPTION BY PASSWORD = ''' + @MKPassword + ''''
	EXEC sp_executesql @sql
END TRY
BEGIN CATCH
     PRINT 'ERROR 2: ' + ERROR_MESSAGE();
     RETURN
END CATCH

-- Step 3.  Restore the "AppScan" certificate using the Master Key and the backup files.
---------------------------------------------------------------------------------------
BEGIN TRY
	SET @sql = 'USE master; IF NOT EXISTS (select 1 from sys.certificates  where name = ''APPSCAN_ENT_CERT'') BEGIN ' + 
		'CREATE CERTIFICATE APPSCAN_ENT_CERT FROM FILE = ''' + @Path + 'AppScanEntCert.bak'' WITH PRIVATE KEY (FILE = ''' + @Path + 'AppScanEntCert.pvk'', ' + 
		' DECRYPTION BY PASSWORD = ''' + @BackupPassword + ''');  END' 
	EXEC sp_executesql @sql
END TRY
BEGIN CATCH
     PRINT 'ERROR 3: ' + ERROR_MESSAGE();
     RETURN
END CATCH
-- Step 4.  Display the result.
---------------------------------------------------------------------------------------
BEGIN TRY
	PRINT 'The certificate is successfully restored, you can restore the database.'
END TRY
BEGIN CATCH
     PRINT 'ERROR 4: ' + ERROR_MESSAGE();
     RETURN
END CATCH
